/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import java.io.IOException;
import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;
import net.wicp.tams.common.binlog.parser.event.QueryLogEvent;

public final class ExecuteLoadQueryLogEvent
extends QueryLogEvent {
    private long fileId;
    private int fnPosStart;
    private int fnPosEnd;
    public static final int LOAD_DUP_ERROR = 0;
    public static final int LOAD_DUP_IGNORE = 1;
    public static final int LOAD_DUP_REPLACE = 2;
    private int dupHandling;
    public static final int ELQ_FILE_ID_OFFSET = 13;
    public static final int ELQ_FN_POS_START_OFFSET = 17;
    public static final int ELQ_FN_POS_END_OFFSET = 21;
    public static final int ELQ_DUP_HANDLING_OFFSET = 25;

    public ExecuteLoadQueryLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) throws IOException {
        super(header, buffer, descriptionEvent);
        buffer.position(descriptionEvent.commonHeaderLen + 13);
        this.fileId = buffer.getUint32();
        this.fnPosStart = (int)buffer.getUint32();
        this.fnPosEnd = (int)buffer.getUint32();
        this.dupHandling = buffer.getInt8();
        int len = this.query.length();
        if (this.fnPosStart > len || this.fnPosEnd > len || this.dupHandling > 2) {
            throw new IOException(String.format("Invalid ExecuteLoadQueryLogEvent: fn_pos_start=%d, fn_pos_end=%d, dup_handling=%d", this.fnPosStart, this.fnPosEnd, this.dupHandling));
        }
    }

    public final int getFilenamePosStart() {
        return this.fnPosStart;
    }

    public final int getFilenamePosEnd() {
        return this.fnPosEnd;
    }

    public final String getFilename() {
        if (this.query != null) {
            return this.query.substring(this.fnPosStart, this.fnPosEnd).trim();
        }
        return null;
    }

    public final long getFileId() {
        return this.fileId;
    }
}

