/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.sender.impl.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import net.wicp.tams.common.binlog.self.bean.SendBean;
import net.wicp.tams.common.binlog.self.bean.SendObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AbsThread.class);
    protected final String perthreadKey = "_sender";
    protected final boolean serialize;
    protected int sucNum;
    protected final List<SendObj> errList;
    protected final ArrayBlockingQueue<SendBean> queue;

    public AbsThread(int querySize, boolean serialize) {
        this.queue = new ArrayBlockingQueue(querySize > 0 ? querySize : 256);
        this.errList = new ArrayList<SendObj>();
        this.serialize = serialize;
    }

    @Override
    public void run() {
        while (true) {
            SendBean sendBean = null;
            try {
                sendBean = this.queue.take();
                this.doSingle(sendBean);
                ++this.sucNum;
                this.logSuc(log, sendBean);
                continue;
            }
            catch (Throwable e) {
                String beaninfo = sendBean == null ? "" : sendBean.toSendObj().toString();
                log.error("\u9519\u8bef\u5bf9\u8c61:[{}],\u9519\u8bef\u539f\u56e0:[{}]", (Object)beaninfo, (Object)e.getMessage());
                if (sendBean == null) continue;
                this.errList.add(sendBean.toSendObj());
                continue;
            }
            break;
        }
    }

    protected abstract void doSingle(SendBean var1);

    protected abstract void logSuc(Logger var1, SendBean var2);

    public void initData() {
        this.sucNum = 0;
        this.errList.clear();
    }

    public void addData(SendBean sendBean) throws InterruptedException {
        this.queue.put(sendBean);
    }
}

