/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.sender;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.bean.SendBean;
import net.wicp.tams.common.binlog.self.bean.SendMoniter;
import net.wicp.tams.common.binlog.self.bean.SendRow;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.constant.dic.YesOrNo;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;

public abstract class AbsSender
implements ISender {
    protected Logger log;
    protected String taskId;
    protected boolean serialize;
    protected YesOrNo multiThread = YesOrNo.no;
    protected int threadNum = -1;
    protected int querySize = -1;
    protected int tableNum = -1;
    protected String splitKey;
    protected YesOrNo sendByTable = YesOrNo.yes;
    protected volatile int insertNum = 0;
    protected volatile int updateNum = 0;
    protected volatile int deleteNum = 0;
    protected volatile long sendTimes = 0L;

    @Override
    public final Result sendMsg(SendBean sendBean) {
        long begin = System.currentTimeMillis();
        Result ret = null;
        if (this.sendByTable == YesOrNo.yes) {
            ret = this.sendMsgSub(sendBean);
        } else {
            List<SendBean> list = this.spilSendBean(sendBean);
            for (SendBean sendBean2 : list) {
                this.sendMsgSub(sendBean2);
            }
            ret = Result.getSuc();
        }
        if (ret.isSuc()) {
            int inccount = sendBean.getRows().size();
            switch (sendBean.getOptType()) {
                case insert: {
                    this.insertNum += inccount;
                    break;
                }
                case update: {
                    this.updateNum += inccount;
                    break;
                }
                case delete: {
                    this.deleteNum += inccount;
                    break;
                }
            }
        }
        this.sendTimes += System.currentTimeMillis() - begin;
        return ret;
    }

    @Override
    public final void init(Logger log, String taskId, Map<String, String> params) {
        this.taskId = taskId;
        this.log = log;
        if (MapUtils.isNotEmpty(params)) {
            if ("true".equals(params.get("serialize"))) {
                this.serialize = true;
            }
            if ("yes".equals(params.get("_multiThread"))) {
                this.multiThread = YesOrNo.yes;
            }
            if (params.containsKey("_threadNum")) {
                this.threadNum = Integer.parseInt(params.get("_threadNum"));
            }
            if (this.multiThread == YesOrNo.yes && this.threadNum <= 0) {
                throw new IllegalArgumentException("\u591a\u7ebf\u7a0b\u9700\u8981\u8bbe\u7f6e\u7ebf\u7a0b\u6570");
            }
            if (this.multiThread == YesOrNo.no) {
                this.threadNum = 1;
            }
            if (params.containsKey("_querySize")) {
                this.querySize = Integer.parseInt(params.get("_querySize"));
            }
            if (params.containsKey("_splitKey")) {
                this.splitKey = params.get("_splitKey");
            }
            this.splitKey = StringUtil.hasNull((String[])new String[]{this.splitKey, "id"});
            if (params.containsKey("_tableNum")) {
                this.tableNum = Integer.parseInt(params.get("_tableNum"));
            }
            this.sendByTable = "yes".equals(params.get("_sendByTable")) ? YesOrNo.yes : ("no".equals(params.get("_sendByTable")) ? YesOrNo.no : null);
            if (this.sendByTable == null) {
                this.sendByTable = this.tableNum > 0 && this.threadNum > 0 && this.tableNum >= this.threadNum ? YesOrNo.yes : YesOrNo.no;
            }
        }
        this.initSub(params);
    }

    @Override
    public SendMoniter getMoniter() {
        return SendMoniter.builder().insertNum(this.insertNum).updateNum(this.updateNum).deleteNum(this.deleteNum).sendTimes(this.sendTimes).sendByTable(this.sendByTable).build();
    }

    @Override
    public void initMoniter(SendMoniter sendMoniter) {
        this.insertNum = sendMoniter.getInsertNum();
        this.updateNum = sendMoniter.getUpdateNum();
        this.deleteNum = sendMoniter.getDeleteNum();
        this.sendTimes = sendMoniter.getSendTimes();
    }

    protected long getGtidOrder(SendBean sendBean) {
        int begin = sendBean.getGtid().indexOf("-");
        int end = sendBean.getGtid().indexOf(",");
        String retstr = end > 0 ? sendBean.getGtid().substring(begin + 1, end) : sendBean.getGtid().substring(begin + 1);
        return Long.valueOf(retstr);
    }

    protected List<SendBean> spilSendBean(SendBean sendBean) {
        ArrayList<SendBean> retlist = new ArrayList<SendBean>();
        if (sendBean.getRows().size() == 1) {
            retlist.add(sendBean);
        } else {
            for (SendRow i : sendBean.getRows()) {
                SendBean tempSendBean = SendBean.builder().columnCount(sendBean.getColumnCount()).gtid(sendBean.getGtid()).optType(sendBean.getOptType()).tableMapBean(sendBean.getTableMapBean()).build();
                tempSendBean.setRows(Arrays.asList(i));
                retlist.add(tempSendBean);
            }
        }
        return retlist;
    }

    public abstract void initSub(Map<String, String> var1);

    public abstract Result sendMsgSub(SendBean var1);
}

