/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.replication.up.command;

import java.util.Collection;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.binlog.self.GtidSet;
import net.wicp.tams.common.binlog.self.constant.Command;
import net.wicp.tams.common.binlog.self.replication.up.command.AbsCommand;

public class ComBinlogDumpGtid
extends AbsCommand {
    private static final long serialVersionUID = 1L;
    private long serverId;
    private String binlogFilename = "";
    private long binlogPos = 4L;
    private GtidSet gtidSet;

    public ComBinlogDumpGtid() {
        super(Command.COM_BINLOG_DUMP_GTID);
    }

    @Override
    public void packPacket(ByteUtil.AssitWrite assit) {
        assit.write(this.command.getValue(), 1);
        assit.write(0, 2);
        assit.write(this.serverId, 4);
        assit.write(this.binlogFilename.length(), 4);
        assit.write(this.binlogFilename);
        assit.write(this.binlogPos, 8);
        Collection<GtidSet.UUIDSet> uuidSets = this.gtidSet.getUUIDSets();
        int dataSize = 8;
        for (GtidSet.UUIDSet uuidSet : uuidSets) {
            dataSize += 24 + uuidSet.getIntervals().size() * 16;
        }
        assit.write(dataSize, 4);
        assit.write((long)uuidSets.size(), 8);
        for (GtidSet.UUIDSet uuidSet : uuidSets) {
            assit.write(ComBinlogDumpGtid.hexToByteArray(uuidSet.getUUID().replace("-", "")));
            Collection<GtidSet.Interval> intervals = uuidSet.getIntervals();
            assit.write((long)intervals.size(), 8);
            for (GtidSet.Interval interval : intervals) {
                assit.write(interval.getStart(), 8);
                assit.write(interval.getEnd() + 1L, 8);
            }
        }
    }

    private static byte[] hexToByteArray(String uuid) {
        byte[] b = new byte[uuid.length() / 2];
        int i = 0;
        for (int j = 0; j < uuid.length(); j += 2) {
            b[i++] = (byte)Integer.parseInt(uuid.charAt(j) + "" + uuid.charAt(j + 1), 16);
        }
        return b;
    }

    @Override
    protected Result check() {
        if (this.gtidSet == null) {
            return Result.getError((String)"need gtid");
        }
        return Result.getSuc();
    }

    public GtidSet getGtidSet() {
        return this.gtidSet;
    }

    public void setGtidSet(GtidSet gtidSet) {
        this.gtidSet = gtidSet;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public String getBinlogFilename() {
        return this.binlogFilename;
    }

    public void setBinlogFilename(String binlogFilename) {
        this.binlogFilename = binlogFilename;
    }

    public long getBinlogPos() {
        return this.binlogPos;
    }

    public void setBinlogPos(long binlogPos) {
        this.binlogPos = binlogPos;
    }
}

