/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.replication.up;

import java.io.UnsupportedEncodingException;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.MysqlUtil;
import net.wicp.tams.common.binlog.self.constant.CapabilityFlags;
import net.wicp.tams.common.binlog.self.replication.AbsPacketWrite;
import net.wicp.tams.common.binlog.self.replication.down.GreetingPacket;

public class SecurePasswordAuthenticationPacket
extends AbsPacketWrite {
    private static final long serialVersionUID = 1L;
    private final GreetingPacket greetingPacket;
    private String user;
    private String password;
    private String defaultSchema;
    private int clientCapabilities;
    private int maximumPacketLength;
    protected int clientCollation;

    public SecurePasswordAuthenticationPacket(GreetingPacket greetingPacket) {
        this.greetingPacket = greetingPacket;
    }

    @Override
    public void packPacket(ByteUtil.AssitWrite assit) {
        assit.write(this.buildClientCapabilities(), 4);
        assit.write(this.maximumPacketLength, 4);
        assit.write(this.clientCollation > 0 ? this.clientCollation : this.greetingPacket.getServerCollation(), 1);
        assit.write(0, 23);
        try {
            assit.writeEndNull(this.user.getBytes("UTF-8"));
            assit.write(20, 1);
            assit.write(MysqlUtil.password41OrLater(this.password.getBytes("UTF-8"), this.greetingPacket.getScramble().getBytes("UTF-8")));
            if (StringUtil.isNotNull((Object)this.defaultSchema)) {
                assit.writeEndNull(this.defaultSchema.getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    protected Result check() {
        if (StringUtil.isNull((Object)this.user) || StringUtil.isNull((Object)this.password) || this.greetingPacket == null) {
            return Result.getError((String)"\u975e\u6cd5\u53c2\u6570\uff0c\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u6b22\u8fce\u5305\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.getSuc();
    }

    protected int buildClientCapabilities() {
        int r;
        int n = r = this.clientCapabilities > 0 ? this.clientCapabilities : CapabilityFlags.defaultCapability();
        if (StringUtil.isNotNull((Object)this.defaultSchema)) {
            r |= CapabilityFlags.CLIENT_CONNECT_WITH_DB.getValue();
        }
        return r;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public int getClientCapabilities() {
        return this.clientCapabilities;
    }

    public void setClientCapabilities(int clientCapabilities) {
        this.clientCapabilities = clientCapabilities;
    }

    public int getMaximumPacketLength() {
        return this.maximumPacketLength;
    }

    public void setMaximumPacketLength(int maximumPacketLength) {
        this.maximumPacketLength = maximumPacketLength;
    }

    public int getClientCollation() {
        return this.clientCollation;
    }

    public void setClientCollation(int clientCollation) {
        this.clientCollation = clientCollation;
    }
}

