/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.replication.down;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.binlog.self.replication.AbsPacketRead;

public class RsFieldPacket
extends AbsPacketRead {
    private static final long serialVersionUID = 1L;
    private String catalog;
    private String db;
    private String table;
    private String orginalTable;
    private String column;
    private String originalColumn;
    private int fixed12;
    private int charset;
    private long fieldLength;
    private ColumnType fieldType;
    private int fieldOptions;
    private int decimalPrecision;
    private int reserved;
    private String defaultValue;

    public RsFieldPacket(PacketBean packetBean) {
        super(packetBean);
    }

    @Override
    public JSONObject getBody() {
        JSONObject retobj = JSONUtil.packParams((Object[])new Object[]{"catalog", this.catalog, "db", this.db, "table", this.table, "orginalTable", this.orginalTable, "column", this.column, "originalColumn", this.originalColumn, "fixed12", this.fixed12, "charset", this.charset, "fieldLength", this.fieldLength, "fieldType", this.fieldType.name(), "fieldOptions", this.fieldOptions, "decimalPrecision", this.decimalPrecision, "reserved", this.reserved, "defaultValue", this.defaultValue});
        return retobj;
    }

    @Override
    protected void readBody() throws IOException {
        this.catalog = this.buff.getStringPackLong(this.charsetName);
        this.db = this.buff.getStringPackLong(this.charsetName);
        this.table = this.buff.getStringPackLong(this.charsetName);
        this.orginalTable = this.buff.getStringPackLong(this.charsetName);
        this.column = this.buff.getStringPackLong(this.charsetName);
        this.originalColumn = this.buff.getStringPackLong(this.charsetName);
        this.fixed12 = this.buff.getInt8();
        this.charset = this.buff.getInt16();
        this.fieldLength = this.buff.getInt32();
        this.fieldType = ColumnType.get(this.buff.getUint8());
        this.fieldOptions = this.buff.getInt16();
        this.decimalPrecision = this.buff.getInt8();
        this.reserved = this.buff.getInt16();
        if (this.buff.hasRemaining()) {
            this.defaultValue = this.buff.getStringPackLong(this.charsetName);
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public String getOrginalTable() {
        return this.orginalTable;
    }

    public String getColumn() {
        return this.column;
    }

    public String getOriginalColumn() {
        return this.originalColumn;
    }

    public int getFixed12() {
        return this.fixed12;
    }

    public int getCharset() {
        return this.charset;
    }

    public long getFieldLength() {
        return this.fieldLength;
    }

    public ColumnType getFieldType() {
        return this.fieldType;
    }

    public int getFieldOptions() {
        return this.fieldOptions;
    }

    public int getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public int getReserved() {
        return this.reserved;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

