/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.replication.down;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.constant.StatusFlags;
import net.wicp.tams.common.binlog.self.replication.down.AbsResultPacket;

public class OKPacket
extends AbsResultPacket {
    private static final long serialVersionUID = 1L;
    public static final byte PACKET_MARKER = 0;
    private int packetMarker;
    private long affectedRows;
    private long insertId;
    private StatusFlags serverStatus;
    private int warningCount;
    private String message;

    public OKPacket(PacketBean packetBean) {
        super(packetBean);
    }

    @Override
    protected void readBody() throws IOException {
        this.packetMarker = this.buff.getInt8();
        this.affectedRows = this.buff.getPackedLong();
        this.insertId = this.buff.getPackedLong();
        this.serverStatus = StatusFlags.get(this.buff.getInt16());
        this.warningCount = this.buff.getInt16();
        if (this.buff.hasRemaining()) {
            this.message = this.buff.getStringEndRest(this.charsetName);
        }
    }

    public int getPacketMarker() {
        return this.packetMarker;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getInsertId() {
        return this.insertId;
    }

    public StatusFlags getServerStatus() {
        return this.serverStatus;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public JSONObject getBody() {
        JSONObject retobj = JSONUtil.packParams((Object[])new Object[]{"affectedRows", this.affectedRows, "insertId", this.insertId, "serverStatus", this.serverStatus.name(), "warningCount", this.warningCount, "message", this.message});
        return retobj;
    }

    @Override
    public boolean isSuc() {
        return true;
    }
}

