/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.replication.down;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.constant.CapabilityFlags;
import net.wicp.tams.common.binlog.self.constant.CharacterSet;
import net.wicp.tams.common.binlog.self.replication.AbsPacketRead;

public class GreetingPacket
extends AbsPacketRead {
    private static final long serialVersionUID = 1L;
    int protocolVersion;
    String serverVersion;
    long connectionId;
    CharacterSet characterSet;
    int serverCapabilities;
    private String scramble1;
    private int serverCollation;
    private int serverStatus;
    private String scramble2;
    private String pluginProvidedData;

    public String getScramble() {
        return this.scramble1 + this.scramble2;
    }

    @Override
    protected void readBody() throws IOException {
        this.protocolVersion = this.buff.getInt8();
        this.serverVersion = this.buff.getStringEndNull(this.charsetName);
        this.connectionId = this.buff.getInt32();
        this.scramble1 = this.buff.getStringEndNull(this.charsetName);
        this.serverCapabilities = this.buff.getInt16();
        this.serverCollation = this.buff.getInt8();
        this.serverStatus = this.buff.getInt16();
        this.buff.forward(13);
        this.scramble2 = this.buff.getStringEndNull(this.charsetName);
        if (this.buff.hasRemaining()) {
            this.pluginProvidedData = this.buff.getStringEndNull(this.charsetName);
        }
    }

    public void readBodyNew(ByteUtil.AssitRead reader) throws IOException {
        System.out.println(this.packetBean.getBody());
        this.protocolVersion = ByteUtil.readIntL((byte[])reader.readBytes(1));
        this.serverVersion = reader.readStringEndNull();
        this.connectionId = ByteUtil.readLongL((byte[])reader.readBytes(4));
        String authPluginDataPart1 = ByteUtil.readString((byte[])reader.readBytes(8));
        reader.skip(1);
        byte[] capabilityFlags1 = reader.readBytes(2);
        if (reader.hasMore()) {
            this.characterSet = CharacterSet.get(reader.readByte());
            reader.skip(2);
            byte[] capabilityFlags2 = reader.readBytes(2);
            byte[] capabilitiesByte = new byte[]{capabilityFlags2[0], capabilityFlags2[1], capabilityFlags1[0], capabilityFlags1[1]};
            this.serverCapabilities = (int)ByteUtil.readLongB((byte[])capabilitiesByte);
            int authPluginDataLength = 0;
            if ((this.serverCapabilities & CapabilityFlags.CLIENT_PLUGIN_AUTH.getValue()) != 0) {
                authPluginDataLength = ByteUtil.readIntL((byte[])reader.readBytes(1));
            }
            reader.skip(10);
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public int getServerCollation() {
        return this.serverCollation;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public String getPluginProvidedData() {
        return this.pluginProvidedData;
    }

    public GreetingPacket(PacketBean packetBean) {
        super(packetBean);
    }

    @Override
    public JSONObject getBody() {
        JSONObject retobj = JSONUtil.packParams((Object[])new Object[]{"protocolVersion", this.protocolVersion, "serverVersion", this.serverVersion, "connectionId", this.connectionId, "serverCapabilities", this.serverCapabilities, "scramble", this.getScramble(), "serverCollation", this.serverCollation, "serverStatus", this.serverStatus});
        return retobj;
    }
}

