/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.reader;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.IBinlogRead;
import net.wicp.tams.common.binlog.self.IEventRead;
import net.wicp.tams.common.binlog.self.bean.CountNum;
import net.wicp.tams.common.binlog.self.bean.EventHeader;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.bean.Pos;
import net.wicp.tams.common.binlog.self.bean.SendMoniter;
import net.wicp.tams.common.binlog.self.constant.BinLogVersion;
import net.wicp.tams.common.binlog.self.constant.Checksum;
import net.wicp.tams.common.binlog.self.constant.EventType;
import net.wicp.tams.common.binlog.self.event.GtidEvent;
import net.wicp.tams.common.binlog.self.event.RotateEvent;
import net.wicp.tams.common.binlog.self.event.rows.RowsEvent;
import net.wicp.tams.common.binlog.self.replication.down.EOFPacket;
import net.wicp.tams.common.binlog.self.replication.down.ErrorPacket;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinglogReadDump
extends BufferedInputStream
implements IBinlogRead {
    private static final Logger log = LoggerFactory.getLogger(BinglogReadDump.class);
    private String fileName;
    private boolean curFile = false;
    private final ISender[] senders;
    private long curPos;
    private long curTime;
    private long masterServerId;
    private String gtids;
    private final String uuid;
    private final Checksum checksum;
    private String slaveGtids = "";
    private long parserDelaytime = 0L;
    private long parserAndSendTime = 0L;

    public BinglogReadDump(String uuid, Checksum checksum, InputStream in, ISender ... senders) {
        super(in);
        this.uuid = uuid;
        this.checksum = checksum;
        this.senders = senders != null && senders.length > 0 ? senders : null;
    }

    public BinglogReadDump(String uuid, Checksum checksum, InputStream in, String dbPattern, String tbPattern, ISender ... senders) {
        this(uuid, checksum, in, senders);
        Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get((Object)new Host());
        host.setDbPattern(dbPattern);
        host.setTbPattern(tbPattern);
    }

    @Override
    public Result checkHead() {
        try {
            PacketBean bin = PacketBean.buildEventBean(this.in, this.fileName, this.gtids, this.checksum);
            if (bin.getPacketMarker() == -1) {
                ErrorPacket binPacket = new ErrorPacket(bin);
                log.error("\u8bfb\u4e8b\u4ef6\u5305\u51fa\u9519\uff1a[{}]", (Object)binPacket.getBody().toJSONString());
                return Result.getError((String)String.format("\u8bfb\u4e8b\u4ef6\u5305\u51fa\u9519\uff1a[%s]", binPacket.getBody().toJSONString()));
            }
            BinLogVersion binLogVersion = this.getVersion(bin.getEventBean().getHead());
            if (binLogVersion == null || binLogVersion != BinLogVersion.v4) {
                return Result.getError((String)String.format("\u53ea\u652f\u6301v4\u7684binlog\uff0c\u4e0d\u652f\u6301\u7684binlog\u7248\u672c:[%s]", binLogVersion == null ? "" : binLogVersion.name()));
            }
            bin.getEventBean().getEventRead().parseBody(new ISender[0]);
        }
        catch (IOException e) {
            Properties props = IOUtil.fileToProperties((String)"/conf/binlog/FormatDescription.properties", BinglogReadDump.class);
            JSONObject obj = new JSONObject();
            for (Object key : props.keySet()) {
                obj.put(String.valueOf(key), (Object)Integer.parseInt(String.valueOf(props.get(key))));
            }
            EventType.setFormatDescription(obj);
        }
        return Result.getSuc();
    }

    @Override
    public void read(long pos) throws IOException {
        Result checkRet;
        Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get();
        if (!(host != null && EventType.isInit(host) || (checkRet = this.checkHead()).isSuc())) {
            throw new RuntimeException(checkRet.getMessage());
        }
        while (true) {
            PacketBean bin = PacketBean.buildEventBean(this.in, this.fileName, this.gtids, this.checksum);
            this.curPos = bin.getEventBean().getBeginHead();
            this.curTime = bin.getEventBean().getHead().getTimestamp();
            if (bin.getPacketMarker() == -1) {
                ErrorPacket binPacket = new ErrorPacket(bin);
                log.error("\u8bfb\u4e8b\u4ef6\u5305\u51fa\u9519\uff1a[{}]", (Object)binPacket.getBody().toJSONString());
                break;
            }
            if (bin.getPacketMarker() == -2) {
                EOFPacket binPacket = new EOFPacket(bin);
                log.error("\u8bfb\u4e8b\u4ef6\u5305\u7ed3\u675f\uff1a[{}]", (Object)binPacket.getBody().toJSONString());
                continue;
            }
            if (bin.getPacketMarker() == 0) {
                if (bin.getEventBean() == null) break;
                long parserDelaytimeTemp = System.currentTimeMillis() / 1000L - bin.getEventBean().getHead().getTimestamp();
                IEventRead reader = bin.getEventBean().getEventRead();
                if (bin.getEventBean().getHead().getEventType() == EventType.STOP_EVENT) {
                    reader.parseBody(new ISender[0]);
                    if (!this.curFile) continue;
                    break;
                }
                if (bin.getEventBean().getHead().getEventType() == EventType.ROTATE_EVENT) {
                    RotateEvent rotateEvent = (RotateEvent)bin.getEventBean().getEventRead();
                    rotateEvent.parseBody(new ISender[0]);
                    this.fileName = rotateEvent.getNextBinlogName();
                    log.info("\u8df3\u8f6c\u5230\u4e0b\u4e00\u4e2a\u6587\u4ef6:\u3010{}\u3011\uff0c\u4f4d\u7f6e:\u3010{}\u3011", (Object)this.fileName, (Object)rotateEvent.getNextPosition());
                    continue;
                }
                if (bin.getEventBean().getHead().getEventType() == EventType.GTID_EVENT) {
                    GtidEvent gtidEvent = (GtidEvent)bin.getEventBean().getEventRead();
                    gtidEvent.parseBody(this.senders);
                    if (StringUtil.isNotNull((Object)this.uuid) && this.uuid.equals(gtidEvent.getSource())) {
                        if (StringUtil.isNull((Object)this.slaveGtids)) {
                            this.gtids = gtidEvent.getGtid();
                            continue;
                        }
                        this.gtids = String.format("%s,%s", gtidEvent.getGtid(), this.slaveGtids);
                        continue;
                    }
                    log.info("------------------\u505a\u4e3b\u5907\u5207\u6362,\u539f\u4e3b\u673a\u6e90[{}],\u5207\u6362\u6e90[{}}]--------------------------------", (Object)this.uuid, (Object)gtidEvent.getSource());
                    continue;
                }
                if (bin.getEventBean().getHead().getEventType() == EventType.TABLE_MAP_EVENT || bin.getEventBean().getHead().getEventType() == EventType.FORMAT_DESCRIPTION_EVENT) {
                    reader.parseBody(new ISender[0]);
                    continue;
                }
                if (reader instanceof RowsEvent) {
                    long beginParseTimeTemp = System.currentTimeMillis();
                    Result ret = reader.parseBody(this.senders);
                    if (ret == null) continue;
                    if (!ret.isSuc() && StringUtil.isNotNull((Object)ret.getMessage())) {
                        log.error("errormsg:[{}]", (Object)ret.getMessage());
                        continue;
                    }
                    this.parserDelaytime += parserDelaytimeTemp;
                    this.parserAndSendTime += System.currentTimeMillis() - beginParseTimeTemp;
                    continue;
                }
                log.info("\u6682\u4e0d\u652f\u6301\u7684\u4e8b\u4ef6:[{}]", (Object)bin.getEventBean().getHead().getEventType());
                continue;
            }
            log.error("\u4e0d\u8ba4\u8bc6\u7684\u5305,\u5305\u8bc6\u522b\u7801[{}]", (Object)bin.getPacketMarker());
        }
    }

    protected BinLogVersion getVersion(EventHeader firstHead) {
        if (firstHead == null) {
            return null;
        }
        BinLogVersion retobj = null;
        switch (firstHead.getEventType()) {
            case FORMAT_DESCRIPTION_EVENT: {
                retobj = BinLogVersion.v4;
                break;
            }
            case START_EVENT_V3: {
                long eventSize = firstHead.getEventSize();
                if (eventSize == 69L) {
                    return BinLogVersion.v1;
                }
                if (eventSize != 75L) break;
                return BinLogVersion.v3;
            }
        }
        return retobj;
    }

    public long getCurPos() {
        return this.pos;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isCurFile() {
        return this.curFile;
    }

    public void setCurFile(boolean curFile) {
        this.curFile = curFile;
    }

    @Override
    public Pos curPos() {
        Pos ret = new Pos();
        ret.setFileName(this.fileName);
        ret.setPos(this.curPos);
        ret.setTime(this.curTime);
        ret.setMasterServerId(this.masterServerId);
        ret.setGtids(this.gtids);
        return ret;
    }

    @Override
    public void resetNum() {
        this.parserDelaytime = 0L;
        this.parserAndSendTime = 0L;
        SendMoniter initbean = SendMoniter.builder().insertNum(0).updateNum(0).deleteNum(0).sendTimes(0L).build();
        for (ISender sender : this.senders) {
            sender.initMoniter(initbean);
        }
    }

    @Override
    public CountNum getCountNum() {
        long sendtimes = 0L;
        for (ISender iSender : this.senders) {
            sendtimes += iSender.getMoniter().getSendTimes();
        }
        SendMoniter sendMoniter = this.senders[0].getMoniter();
        CountNum countNum = CountNum.builder().insertNum(sendMoniter.getInsertNum()).updateNum(sendMoniter.getUpdateNum()).deleteNum(sendMoniter.getDeleteNum()).parserDelayTime(this.parserDelaytime).parserAndSendTime(this.parserAndSendTime).sendTime(sendtimes).build();
        return countNum;
    }

    public void initCountNum(CountNum countNum) {
        if (countNum == null) {
            return;
        }
        this.parserDelaytime = countNum.getParserDelayTime();
        this.parserAndSendTime = countNum.getParserAndSendTime();
        long sendtime = countNum.getSendTime() / (long)this.senders.length;
        SendMoniter intobj = SendMoniter.builder().insertNum((int)countNum.getInsertNum()).updateNum((int)countNum.getUpdateNum()).deleteNum((int)countNum.getDeleteNum()).sendTimes(sendtime).build();
        for (ISender send : this.senders) {
            send.initMoniter(intobj);
        }
    }

    public void setMasterServerId(long masterServerId) {
        this.masterServerId = masterServerId;
    }

    public void setGtids(String gtids) {
        if (StringUtil.isNull((Object)gtids)) {
            this.gtids = null;
            this.slaveGtids = null;
        } else {
            Object[] gtidsAry;
            this.gtids = gtids.replace("\n", "");
            for (String string : gtidsAry = this.gtids.split(",")) {
                if (!string.startsWith(this.uuid)) continue;
                gtidsAry = (String[])ArrayUtils.removeElement((Object[])gtidsAry, (Object)string);
                break;
            }
            this.slaveGtids = CollectionUtil.arrayJoin((Object[])gtidsAry, (String)",");
        }
    }
}

