/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.reader;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.IBinlogRead;
import net.wicp.tams.common.binlog.self.IEventRead;
import net.wicp.tams.common.binlog.self.MysqlUtil;
import net.wicp.tams.common.binlog.self.bean.CountNum;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.bean.EventHeader;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.bean.Pos;
import net.wicp.tams.common.binlog.self.constant.BinLogVersion;
import net.wicp.tams.common.binlog.self.constant.Checksum;
import net.wicp.tams.common.binlog.self.constant.EventFlag;
import net.wicp.tams.common.binlog.self.constant.EventType;
import net.wicp.tams.common.binlog.self.event.AbsEvent;
import net.wicp.tams.common.binlog.self.event.FormatDescription;
import net.wicp.tams.common.binlog.self.event.GtidEvent;
import net.wicp.tams.common.binlog.self.event.rows.RowsEvent;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.io.InputStreamRamdomRead;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinglogReadByFile
extends InputStreamRamdomRead
implements IBinlogRead {
    private static final Logger log = LoggerFactory.getLogger(BinglogReadByFile.class);
    private EventBean firstEvent;
    private Checksum checksum;
    private final String fileName;
    private final ISender[] senders;
    private long curTime = 0L;
    private long insertNum = 0L;
    private long updateNum = 0L;
    private long deleteNum = 0L;
    private long endPos = -1L;
    private String beginGtid;
    private String endGtid;
    private boolean isbegin = false;
    private String gtids;

    public BinglogReadByFile(File file, Checksum checksum, ISender ... senders) throws IOException {
        super(file);
        this.checksum = checksum;
        this.fileName = file.getName();
        this.senders = senders != null && senders.length > 0 ? senders : null;
        Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get((Object)new Host());
        host.setHostIp("127.0.0.1");
        host.setPort(3306);
        host.setDefaultDb("mysql");
        host.setUser("root");
        host.setPwd("111111");
        PerthreadManager.getInstance().createValue((Object)"zorro-host").set((Object)host);
    }

    public BinglogReadByFile(File file, String dbPattern, String tbPattern, Checksum checksum, ISender ... senders) throws IOException {
        this(file, checksum, senders);
        Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get((Object)new Host());
        host.setDbPattern(dbPattern);
        host.setTbPattern(tbPattern);
    }

    @Override
    public Result checkHead() {
        try {
            this.seek(0L);
        }
        catch (IOException e1) {
            log.error("\u4e0d\u80fd\u8df3\u5230\u9996\u4f4d\u53bb\u68c0\u67e5\uff0c\u4e0d\u5408\u6cd5", (Throwable)e1);
            throw new IllegalAccessError("\u4e0d\u80fd\u8df3\u5230\u9996\u4f4d\u53bb\u68c0\u67e5\uff0c\u4e0d\u5408\u6cd5");
        }
        try {
            byte[] magic = this.readBytes(BINLOG_MAGIC.length);
            if (!Arrays.equals(magic, BINLOG_MAGIC)) {
                return Result.getError((String)String.format("\u4e0d\u5408\u6cd5\u7684binlog\u6587\u4ef6:[%s]", this.fileName));
            }
            this.firstEvent = this.readEvent();
            BinLogVersion binLogVersion = this.getVersion(this.firstEvent.getHead());
            if (binLogVersion == null || binLogVersion != BinLogVersion.v4) {
                return Result.getError((String)String.format("\u53ea\u652f\u6301v4\u7684binlog\uff0c\u4e0d\u652f\u6301\u7684binlog\u7248\u672c:[%s]", binLogVersion == null ? "" : binLogVersion.name()));
            }
            return Result.getSuc();
        }
        catch (Exception e) {
            return Result.getError((String)String.format("\u8bfbbinlog\u6587\u4ef6:[%s]\u9519\u8bef", this.fileName));
        }
    }

    public BinLogVersion getVersion(EventHeader firstHead) {
        if (firstHead == null) {
            return null;
        }
        BinLogVersion retobj = null;
        switch (firstHead.getEventType()) {
            case FORMAT_DESCRIPTION_EVENT: {
                retobj = BinLogVersion.v4;
                break;
            }
            case START_EVENT_V3: {
                long eventSize = firstHead.getEventSize();
                if (eventSize == 69L) {
                    return BinLogVersion.v1;
                }
                if (eventSize != 75L) break;
                return BinLogVersion.v3;
            }
        }
        return retobj;
    }

    @Override
    public void read(long pos) throws IOException {
        Result checkRet = this.checkHead();
        if (!checkRet.isSuc()) {
            throw new RuntimeException(checkRet.getMessage());
        }
        IEventRead reader = new FormatDescription(this.firstEvent);
        reader.parseBody(this.senders);
        if (pos > this.firstEvent.getHead().getNextEventPos()) {
            this.seek(pos);
        }
        while (this.available() > 0) {
            EventBean curEvent = this.readEvent();
            if (this.endPos > 0L && curEvent.getBeginHead() > this.endPos) break;
            if (curEvent.getHead().getEventType() == EventType.GTID_EVENT) {
                if (StringUtil.isNull((Object)this.beginGtid) && StringUtil.isNull((Object)this.endGtid)) {
                    this.isbegin = true;
                }
                GtidEvent gtidEvent = (GtidEvent)curEvent.getEventRead();
                gtidEvent.parseBody(this.senders);
                this.gtids = gtidEvent.getGtid();
                if (StringUtil.isNotNull((Object)this.beginGtid) && MysqlUtil.compare(this.gtids, this.beginGtid) >= 0) {
                    this.isbegin = true;
                }
                if (!StringUtil.isNotNull((Object)this.endGtid) || MysqlUtil.compare(this.gtids, this.endGtid) <= 0) continue;
                break;
            }
            if (!this.isbegin) continue;
            this.curTime = curEvent.getHead().getTimestamp();
            reader = curEvent.getEventRead();
            Result ret = null;
            ret = reader instanceof RowsEvent ? reader.parseBody(this.senders) : reader.parseBody(new ISender[0]);
            if (ret != null) {
                log.info(ret.getMessage());
            }
            if (!(curEvent.getEventRead() instanceof RowsEvent)) continue;
            RowsEvent rd = (RowsEvent)curEvent.getEventRead();
            switch (rd.getOptType()) {
                case insert: {
                    ++this.insertNum;
                    break;
                }
                case update: {
                    ++this.updateNum;
                    break;
                }
                case delete: {
                    ++this.deleteNum;
                    break;
                }
            }
        }
        log.info("\u65e5\u5fd7[{}]\u89e3\u6790\u5b8c\u6210,\u8d77\u59cb\u4f4d\u7f6e[{}]\u7ed3\u675f\u4f4d\u7f6e[{}]", new Object[]{this.fileName, pos, this.endPos});
    }

    private EventBean readEvent() throws IOException {
        if (this.available() <= 0) {
            return null;
        }
        long timestamp = ByteUtil.readLongL((byte[])this.readBytes(4));
        EventType eventType = EventType.get(this.readByte());
        long serverId = ByteUtil.readLongL((byte[])this.readBytes(4));
        long eventSize = ByteUtil.readLongL((byte[])this.readBytes(4));
        long nextEventPos = ByteUtil.readLongL((byte[])this.readBytes(4));
        int checkNum = this.checksum == null ? 0 : this.checksum.getByteNum();
        EventFlag eventFlag = EventFlag.get(ByteUtil.readIntL((byte[])this.readBytes(2)));
        byte[] body = this.readBytes((int)eventSize - 19 - checkNum);
        EventHeader head = EventHeader.builder().timestamp(timestamp).eventType(eventType).serverId(serverId).eventSize(eventSize).nextEventPos(nextEventPos).eventFlag(eventFlag).build();
        EventBean retobj = new EventBean(head, body);
        retobj.setGtids(this.gtids);
        this.skip(checkNum);
        log.info("---------------------------\u4e8b\u4ef6[{}]\u5f00\u59cb\u4f4d\u7f6e\uff1a{}\uff0c\u6570\u636e\u5f00\u59cb\u4f4d\u7f6e{}----------------------------------------------------", new Object[]{eventType == null ? "" : eventType.name(), AbsEvent.row(retobj.getBeginHead()), AbsEvent.row(retobj.getBeginBody())});
        return retobj;
    }

    @Override
    public Pos curPos() {
        Pos ret = new Pos();
        ret.setFileName(this.fileName);
        ret.setPos(this.getCurPos());
        ret.setTime(this.curTime);
        return ret;
    }

    @Override
    public void resetNum() {
        this.insertNum = 0L;
        this.updateNum = 0L;
        this.deleteNum = 0L;
    }

    @Override
    public CountNum getCountNum() {
        CountNum countNum = CountNum.builder().insertNum(this.insertNum).updateNum(this.updateNum).deleteNum(this.deleteNum).build();
        return countNum;
    }

    public long getEndPos() {
        return this.endPos;
    }

    public void setEndPos(long endPos) {
        this.endPos = endPos;
    }

    public void setBeginGtid(String beginGtid) {
        this.beginGtid = beginGtid;
    }

    public void setEndGtid(String endGtid) {
        this.endGtid = endGtid;
    }
}

