/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.event.rows;

import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.bean.SendBean;
import net.wicp.tams.common.binlog.self.bean.SendRow;
import net.wicp.tams.common.binlog.self.bean.TableMapBean;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.event.AbsEvent;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.constant.OptType;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowsEvent
extends AbsEvent {
    private static final Logger log = LoggerFactory.getLogger(RowsEvent.class);
    private static int maxRows = Integer.parseInt(StringUtil.hasNull((String[])new String[]{Conf.get((String)"zorro.sender.max"), "400"}));
    protected int version = 1;
    protected long tableId;
    protected int flags;
    protected long columnCount;
    protected byte[] columnsPresentBitmap1;
    protected byte[] columnsPresentBitmap2;
    protected TableMapBean table;
    protected OptType optType;

    public RowsEvent(EventBean event) {
        super(event);
    }

    @Override
    public final Result parseBody(ISender ... senders) {
        int postHeadLength = this.event.getHead().getEventType().getPostHeaderLength();
        if (postHeadLength == -1) {
            return Result.getError((String)"\u6ca1\u6709\u521d\u59cb\u5316\uff0cFormatDescription\u4e8b\u4ef6\u5fc5\u987b\u7b2c\u4e00\u4e2a\u8bfb.");
        }
        this.tableId = postHeadLength == 6 ? (long)this.logBuffer.getInt32() : this.logBuffer.getLong48();
        Host hostpre = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get();
        this.table = hostpre.findTableMapBean(this.tableId);
        if (this.table == null) {
            return Result.getError((String)("no table" + this.tableId));
        }
        this.flags = this.logBuffer.getInt16();
        if (this.version == 2) {
            int extraDataLength = this.logBuffer.getInt16();
            this.logBuffer.forward(extraDataLength - 2);
        }
        this.columnCount = this.logBuffer.getPackedLong();
        int presentBitmap1Length = ((int)this.columnCount + 7) / 8;
        this.columnsPresentBitmap1 = new byte[presentBitmap1Length];
        this.logBuffer.fillBytes(this.columnsPresentBitmap1, 0, presentBitmap1Length);
        if (this.optType == OptType.update) {
            this.columnsPresentBitmap2 = new byte[presentBitmap1Length];
            this.logBuffer.fillBytes(this.columnsPresentBitmap2, 0, presentBitmap1Length);
        }
        ArrayList<SendRow> rows = new ArrayList<SendRow>();
        while (this.logBuffer.hasRemaining()) {
            List<ICol> row1 = this.paseRow(this.columnsPresentBitmap1, true);
            List<ICol> row2 = null;
            if (this.optType == OptType.update) {
                row2 = this.paseRow(this.columnsPresentBitmap2, false);
            }
            SendRow sendRow = SendRow.builder().before(row1).after(row2).build();
            rows.add(sendRow);
            if (rows.size() < maxRows) continue;
            this.doSend(rows, senders);
            rows = new ArrayList();
        }
        if (CollectionUtils.isNotEmpty(rows)) {
            this.doSend(rows, senders);
        }
        return Result.getSuc();
    }

    private List<ICol> paseRow(byte[] columnsPresentBitmap, boolean isBefore) {
        int presentBitmapNum = ByteUtil.byteshas1((byte[])columnsPresentBitmap);
        int len = (presentBitmapNum + 7) / 8;
        byte[] nulbitmap = this.logBuffer.getData(len);
        ArrayList<ICol> row1 = new ArrayList<ICol>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if ((columnsPresentBitmap[i / 8] & 1 << i % 8) == 0) continue;
            boolean isnull = (nulbitmap[i / 8] & 1 << i % 8) != 0;
            ICol col = this.paseCol(this.table.getColumnTypes()[i], this.table.getCols().get(i), this.table.getMetaDefs()[i], isnull);
            row1.add(col);
            if (col == null) {
                log.error("\u7b2c[{}]\u5217col\u4e3a\u7a7a\u503c\uff0cbinlog is [{}]", (Object)i, (Object)isnull);
                continue;
            }
            if (i != 0 || !isBefore) continue;
            log.info("col0:[{}],value:[{}]", (Object)this.table.getCols().get(i), (Object)col.getClient());
        }
        return row1;
    }

    private Result doSend(List<SendRow> rows, ISender ... senders) {
        Result ret = Result.getSuc();
        for (ISender sender : senders) {
            try {
                SendBean sendBean = SendBean.builder().columnCount((int)this.columnCount).rows(rows).gtid(this.event.getGtids()).tableMapBean(this.table).optType(this.optType).timestamp(this.event.getHead().getTimestamp()).build();
                Result rettemp = sender.sendMsg(sendBean);
                if (rettemp.isSuc()) continue;
                ret = rettemp;
            }
            catch (Throwable e) {
                ret = Result.getError((String)("\u5931\u8d25:" + e.getMessage()));
                log.error("\u53d1\u9001\u8005\u8c03\u7528\u5931\u8d25", e);
            }
        }
        if (senders.length == 1 && !ret.isSuc()) {
            while (true) {
                try {
                    do {
                        log.error("\u552f\u4e00\u7684\u53d1\u9001\u8005\u5931\u8d25,\u6682\u505c\u8fdb\u7a0b3\u79d2\uff0c\u4e8b\u4ef6\u4f4d\u7f6e[{}]", (Object)RowsEvent.row(this.event.getBeginHead()));
                        Thread.sleep(3000L);
                    } while (!(ret = this.doSend(rows, senders)).isSuc());
                }
                catch (InterruptedException e) {
                    log.error("\u552f\u4e00\u7684\u53d1\u9001\u8005\u5931\u8d25\uff0c\u4f11\u606f3\u79d2\u65f6\u51fa\u9519");
                    continue;
                }
                break;
            }
        }
        return ret;
    }

    public OptType getOptType() {
        return this.optType;
    }
}

