/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.event;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.self.LogBuffer;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.bean.TableMapBean;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.binlog.self.event.AbsEvent;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class TableMapEvent
extends AbsEvent {
    private long tableId;
    private int flags;
    private String schemaName;
    private String tableName;
    private long columnCount;
    private ColumnType[] columnTypes;
    private int[] metaDefs;
    private byte[] nullBits;

    public TableMapEvent(EventBean event) {
        super(event);
        event.getBody().limit(event.getBody().limit() + event.getChecksum().getByteNum());
    }

    @Override
    public Result parseBody(ISender ... senders) {
        int postHeadLength = this.event.getHead().getEventType().getPostHeaderLength();
        if (postHeadLength == -1) {
            return Result.getError((String)"\u6ca1\u6709\u521d\u59cb\u5316\uff0cFormatDescription\u4e8b\u4ef6\u5fc5\u987b\u7b2c\u4e00\u4e2a\u8bfb.");
        }
        this.tableId = postHeadLength == 6 ? (long)this.logBuffer.getInt32() : this.logBuffer.getLong48();
        Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get((Object)new Host());
        if (host.containsTabId(this.tableId)) {
            return Result.getSuc((String)"\u5df2\u5b58\u5728\u8be5\u8868\uff0c\u65e0\u9700\u89e3\u6790");
        }
        this.flags = this.logBuffer.getInt16();
        int schemaNameLength = this.logBuffer.getInt8();
        this.schemaName = this.logBuffer.getFixString(schemaNameLength);
        this.logBuffer.forward(1);
        int tableNameLength = this.logBuffer.getInt8();
        this.tableName = this.logBuffer.getFixString(tableNameLength);
        this.logBuffer.forward(1);
        if (!host.checkTable(this.schemaName, this.tableName)) {
            return Result.getSuc((String)"\u8be5\u8868\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u9700\u89e3\u6790");
        }
        this.columnCount = this.logBuffer.getPackedLong();
        this.columnTypes = new ColumnType[(int)this.columnCount];
        int i = 0;
        while ((long)i < this.columnCount) {
            this.columnTypes[i] = ColumnType.get(this.logBuffer.getUint8());
            ++i;
        }
        long meteCount = this.logBuffer.getPackedLong();
        LogBuffer meteBytesBuff = this.logBuffer.duplicate((int)meteCount);
        this.metaDefs = new int[(int)this.columnCount];
        int i2 = 0;
        while ((long)i2 < this.columnCount) {
            int length = this.columnTypes[i2].getMetaLen();
            if (length <= 0) {
                this.metaDefs[i2] = 0;
            } else {
                switch (this.columnTypes[i2]) {
                    case SET: 
                    case ENUM: 
                    case STRING: {
                        this.metaDefs[i2] = (int)meteBytesBuff.readLongB(length);
                        break;
                    }
                    default: {
                        this.metaDefs[i2] = (int)meteBytesBuff.readLongL(length);
                    }
                }
            }
            ++i2;
        }
        int null_bitmapLength = ((int)meteCount + 7) / 8;
        this.nullBits = this.logBuffer.getData(null_bitmapLength);
        host.addTableMapBean(TableMapBean.builder().tableId(this.tableId).flags(this.flags).schemaName(this.schemaName).tableName(this.tableName).columnCount((int)this.columnCount).columnTypes(this.columnTypes).metaDefs(this.metaDefs).nullBits(this.nullBits).build());
        return Result.getSuc();
    }
}

