/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.event;

import com.alibaba.fastjson.JSONArray;
import io.thekraken.grok.api.Match;
import io.thekraken.grok.api.exception.GrokException;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.GrokObj;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.event.AbsEvent;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEvent
extends AbsEvent {
    private static final Logger log = LoggerFactory.getLogger(QueryEvent.class);
    private JSONArray statusVars;
    private String db;
    private String query;

    public QueryEvent(EventBean event) {
        super(event);
    }

    @Override
    public Result parseBody(ISender ... senders) {
        this.logBuffer.forward(8);
        int dbLength = this.logBuffer.getUint8();
        this.logBuffer.forward(2);
        int statusVarsLength = this.logBuffer.getInt16();
        this.logBuffer.forward(statusVarsLength);
        this.db = this.logBuffer.getFixString(dbLength);
        this.logBuffer.forward(1);
        this.query = this.logBuffer.getFixString(this.logBuffer.remaining());
        if (statusVarsLength > 0 && this.query.startsWith("ALTER")) {
            int index = this.query.indexOf("\r\n");
            String firStr = index < 0 ? this.query : this.query.substring(0, index);
            try {
                Match mt = GrokObj.getInstance().match("ALTER TABLE `%{tb}`", firStr);
                String tb = (String)mt.toMap().get("tb");
                if (StringUtil.isNotNull((Object)tb)) {
                    Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get();
                    host.delCols(this.db, tb);
                }
            }
            catch (GrokException e) {
                log.error("\u89e3\u6790\u8868\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            }
        }
        return Result.getSuc();
    }

    public JSONArray getStatusVars() {
        return this.statusVars;
    }

    public String getDb() {
        return this.db;
    }

    public String getQuery() {
        return this.query;
    }

    static {
        GrokObj gm = GrokObj.getInstance();
        gm.addPattern("db", "[A-Za-z0-9_.-:]+");
    }
}

