/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.event;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.event.AbsEvent;
import net.wicp.tams.common.binlog.self.sender.ISender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtidEvent
extends AbsEvent {
    private static final Logger log = LoggerFactory.getLogger(GtidEvent.class);
    private int flags;
    private long gno;
    private String source;
    private String gtid;

    public GtidEvent(EventBean event) {
        super(event);
    }

    @Override
    public Result parseBody(ISender ... senders) {
        this.rowlog("GtidEvent\u4e8b\u4ef6\u7684body\u4f4d\u7f6e");
        this.flags = this.logBuffer.getUint8();
        byte[] sid = this.logBuffer.getData(16);
        this.gno = this.logBuffer.getLong64();
        this.source = this.byteArrayToHex(sid, 0, 4) + "-" + this.byteArrayToHex(sid, 4, 2) + "-" + this.byteArrayToHex(sid, 6, 2) + "-" + this.byteArrayToHex(sid, 8, 2) + "-" + this.byteArrayToHex(sid, 10, 6);
        this.gtid = this.source + ":" + String.format("%d", this.gno);
        log.info("---------------------gtid:[{}]----------------------------------", (Object)this.gtid);
        return Result.getSuc();
    }

    private String byteArrayToHex(byte[] a, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        for (int idx = offset; idx < offset + len && idx < a.length; ++idx) {
            sb.append(String.format("%02x", a[idx] & 0xFF));
        }
        return sb.toString();
    }

    public long getGno() {
        return this.gno;
    }

    public String getGtid() {
        return this.gtid;
    }

    public String getSource() {
        return this.source;
    }
}

