/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.event;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.IEventRead;
import net.wicp.tams.common.binlog.self.LogBuffer;
import net.wicp.tams.common.binlog.self.MysqlUtil;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.callback.column.ColBigDecimal;
import net.wicp.tams.common.binlog.self.callback.column.ColBytes;
import net.wicp.tams.common.binlog.self.callback.column.ColDateSql;
import net.wicp.tams.common.binlog.self.callback.column.ColDateTime;
import net.wicp.tams.common.binlog.self.callback.column.ColDouble;
import net.wicp.tams.common.binlog.self.callback.column.ColFloat;
import net.wicp.tams.common.binlog.self.callback.column.ColInteger;
import net.wicp.tams.common.binlog.self.callback.column.ColLong;
import net.wicp.tams.common.binlog.self.callback.column.ColNull;
import net.wicp.tams.common.binlog.self.callback.column.ColString;
import net.wicp.tams.common.binlog.self.callback.column.ColTimeSql;
import net.wicp.tams.common.binlog.self.callback.column.ColTimestamp;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsEvent
implements IEventRead {
    private static final Logger log = LoggerFactory.getLogger(AbsEvent.class);
    protected final EventBean event;
    protected final LogBuffer logBuffer;
    private Calendar cal;
    protected String charsetName = "UTF-8";

    public AbsEvent(EventBean event) {
        this.event = event;
        this.logBuffer = event.getBody();
        log.info("start\uff1a{},type\uff1a{}", (Object)AbsEvent.row(event.getBeginHead()), (Object)event.getHead().getEventType().name());
    }

    public void rowlog(String info) {
        long temp = this.event.getBeginBody() + (long)this.logBuffer.position();
        log.info("{}:{}", (Object)StringUtil.hasNull((String[])new String[]{info, "\u5f53\u524d\u4f4d\u7f6e"}), (Object)AbsEvent.row(temp));
    }

    public static String stringFill(String source, int fillLength, char fillChar, boolean isLeftFill) {
        int len;
        if (source == null || source.length() >= fillLength) {
            return source;
        }
        StringBuilder result = new StringBuilder(fillLength);
        if (isLeftFill) {
            for (len = fillLength - source.length(); len > 0; --len) {
                result.append(fillChar);
            }
            result.append(source);
        } else {
            result.append(source);
            while (len > 0) {
                result.append(fillChar);
                --len;
            }
        }
        return result.toString();
    }

    protected ICol paseCol(ColumnType colType, String colName, int meta, boolean isnull) {
        if (isnull) {
            return ColNull.builder().colName(colName).colType(colType).value(null).build();
        }
        if (!this.logBuffer.hasRemaining()) {
            throw new IllegalAccessError(String.format("\u89e3\u6790\u5217\u65f6\u51fa\u95ee\u9898\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u6570\u636e\u3002colName:%s,colType:%s", new Object[]{colName, colType}));
        }
        int length = 0;
        if (colType == ColumnType.STRING) {
            if (meta >= 256) {
                int meta0 = meta >> 8;
                int meta1 = meta & 0xFF;
                if ((meta0 & 0x30) != 48) {
                    colType = ColumnType.get(0xFF & (meta0 | 0x30));
                    length = meta1 | (meta0 & 0x30 ^ 0x30) << 4;
                } else {
                    ColumnType meta0Type = ColumnType.get(0xFF & meta0);
                    switch (meta0Type) {
                        case SET: 
                        case ENUM: 
                        case STRING: {
                            colType = ColumnType.get(0xFF & meta0);
                            length = meta1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b: " + (Object)((Object)colType));
                        }
                    }
                }
            } else {
                length = meta;
            }
        }
        switch (colType) {
            case TINY: {
                int val = this.logBuffer.getInt8();
                return new ColInteger(val, colType, colName);
            }
            case SHORT: {
                int val2 = this.logBuffer.getInt16();
                return new ColInteger(val2, colType, colName);
            }
            case INT24: {
                int val3 = this.logBuffer.getInt24();
                return new ColInteger(val3, colType, colName);
            }
            case LONG: {
                long val4 = this.logBuffer.getInt32();
                return new ColLong(val4, colType, colName);
            }
            case LONGLONG: {
                long val5 = this.logBuffer.getLong64();
                return new ColLong(val5, colType, colName);
            }
            case FLOAT: {
                float val6 = this.logBuffer.getFloat32();
                return new ColFloat(Float.valueOf(val6), colType, colName);
            }
            case DOUBLE: {
                double val7 = this.logBuffer.getDouble64();
                return new ColDouble(val7, colType, colName);
            }
            case YEAR: {
                int val8 = this.logBuffer.getUint8();
                return new ColInteger(val8, colType, colName);
            }
            case DATE: {
                int i3211 = this.logBuffer.getUint24();
                if (this.cal == null) {
                    this.cal = Calendar.getInstance();
                }
                this.cal.clear();
                this.cal.set(i3211 / 512, i3211 / 32 % 16 - 1, i3211 % 32);
                return new ColDateSql(new Date(this.cal.getTimeInMillis()), colType, colName);
            }
            case TIME: {
                int i321 = this.logBuffer.getUint24();
                if (this.cal == null) {
                    this.cal = Calendar.getInstance();
                }
                this.cal.clear();
                this.cal.set(70, 0, 1, i321 / 10000, i321 % 10000 / 100, i321 % 100);
                return new ColTimeSql(new Time(this.cal.getTimeInMillis()), colType, colName);
            }
            case DATETIME: {
                long i64 = this.logBuffer.getLong64();
                int d = (int)(i64 / 1000000L);
                int t = (int)(i64 % 1000000L);
                if (this.cal == null) {
                    this.cal = Calendar.getInstance();
                }
                this.cal.clear();
                this.cal.set(d / 10000, d % 10000 / 100 - 1, d % 100, t / 10000, t % 10000 / 100, t % 100);
                return new ColDateTime(new Timestamp(this.cal.getTimeInMillis()), colType, colName);
            }
            case TIMESTAMP: {
                long i32 = this.logBuffer.getUint32();
                return new ColTimestamp(new Timestamp(i32 * 1000L), colType, colName);
            }
            case ENUM: {
                int int32 = 0;
                switch (length) {
                    case 1: {
                        int32 = this.logBuffer.getUint8();
                        break;
                    }
                    case 2: {
                        int32 = this.logBuffer.getUint16();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("!! Unknown ENUM packlen = " + length);
                    }
                }
                log.warn("MYSQL_TYPE_ENUM : This enumeration value is only used internally and cannot exist in a binlog!");
                return new ColInteger(int32, colType, colName);
            }
            case SET: {
                byte[] nbits1 = new byte[length];
                this.logBuffer.fillBytes(nbits1, 0, length);
                log.warn("MYSQL_TYPE_SET : This enumeration value is only used internally and cannot exist in a binlog!");
                long val14 = ByteUtil.readLongL((byte[])nbits1);
                return new ColLong(val14, colType, colName);
            }
            case BIT: {
                int nbits = (meta >> 8) * 8 + (meta & 0xFF);
                length = (nbits + 7) / 8;
                if (nbits > 1) {
                    byte[] bits = new byte[length];
                    this.logBuffer.fillBytes(bits, 0, length);
                    return new ColBytes(bits, colType, colName);
                }
                Integer bit = this.logBuffer.getInt8();
                return new ColBytes(new byte[]{bit.byteValue()}, colType, colName);
            }
            case BLOB: {
                byte[] ret = null;
                switch (meta) {
                    case 1: {
                        int len8 = this.logBuffer.getUint8();
                        ret = new byte[len8];
                        this.logBuffer.fillBytes(ret, 0, len8);
                        break;
                    }
                    case 2: {
                        int len16 = this.logBuffer.getUint16();
                        ret = new byte[len16];
                        this.logBuffer.fillBytes(ret, 0, len16);
                        break;
                    }
                    case 3: {
                        int len24 = this.logBuffer.getUint24();
                        ret = new byte[len24];
                        this.logBuffer.fillBytes(ret, 0, len24);
                        break;
                    }
                    case 4: {
                        int len32 = (int)this.logBuffer.getUint32();
                        ret = new byte[len32];
                        this.logBuffer.fillBytes(ret, 0, len32);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("!! Unknown BLOB packlen = " + meta);
                    }
                }
                return new ColBytes(ret, colType, colName);
            }
            case NEWDECIMAL: {
                int precision = meta & 0xFF;
                int decimals = meta >> 8;
                BigDecimal bd = this.logBuffer.getDecimal(precision, decimals);
                return new ColBigDecimal(bd, colType, colName);
            }
            case STRING: {
                length = length < 256 ? this.logBuffer.getUint8() : this.logBuffer.getUint16();
                return new ColString(this.logBuffer.getFullString(length, this.charsetName), colType, colName);
            }
            case VARCHAR: 
            case VAR_STRING: {
                length = meta < 256 ? this.logBuffer.getUint8() : this.logBuffer.getUint16();
                return new ColString(this.logBuffer.getFullString(length, this.charsetName), colType, colName);
            }
            case TIME_V2: {
                long intpart1 = 0L;
                int frac1 = 0;
                long ltime = 0L;
                switch (meta) {
                    case 0: {
                        intpart1 = (long)this.logBuffer.getBeUint24() - 0x800000L;
                        ltime = intpart1 << 24;
                        break;
                    }
                    case 1: 
                    case 2: {
                        intpart1 = (long)this.logBuffer.getBeUint24() - 0x800000L;
                        frac1 = this.logBuffer.getUint8();
                        if (intpart1 < 0L && frac1 > 0) {
                            ++intpart1;
                            frac1 -= 256;
                        }
                        ltime = intpart1 << 24 + frac1 * 10000;
                        break;
                    }
                    case 3: 
                    case 4: {
                        intpart1 = (long)this.logBuffer.getBeUint24() - 0x800000L;
                        frac1 = this.logBuffer.getBeUint16();
                        if (intpart1 < 0L && frac1 > 0) {
                            ++intpart1;
                            frac1 -= 65536;
                        }
                        ltime = intpart1 << 24 + frac1 * 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        ltime = intpart1 = this.logBuffer.getBeUlong48() - 0x800000L;
                        break;
                    }
                    default: {
                        intpart1 = (long)this.logBuffer.getBeUint24() - 0x800000L;
                        ltime = intpart1 << 24;
                    }
                }
                long ultime = Math.abs(ltime);
                intpart1 = ultime >> 24;
                if (this.cal == null) {
                    this.cal = Calendar.getInstance();
                }
                this.cal.clear();
                this.cal.set(70, 0, 1, (int)((intpart1 >> 12) % 1024L), (int)((intpart1 >> 6) % 64L), (int)(intpart1 % 64L));
                return new ColTimeSql(new Time(this.cal.getTimeInMillis()), colType, colName);
            }
            case DATETIME_V2: {
                long value2 = this.logBuffer.readLongB(5);
                int nanos2 = (int)this.logBuffer.readLongB((meta + 1) / 2);
                java.util.Date val21 = MysqlUtil.toDatetime2(value2, nanos2);
                return new ColDateTime(val21, colType, colName);
            }
            case TIMESTAMP_V2: {
                long tv_sec = this.logBuffer.getBeUint32();
                int tv_usec = 0;
                switch (meta) {
                    case 0: {
                        tv_usec = 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        tv_usec = this.logBuffer.getInt8() * 10000;
                        break;
                    }
                    case 3: 
                    case 4: {
                        tv_usec = this.logBuffer.getBeInt16() * 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        tv_usec = this.logBuffer.getBeInt24();
                        break;
                    }
                    default: {
                        tv_usec = 0;
                    }
                }
                Timestamp time = new Timestamp(tv_sec * 1000L);
                time.setNanos(tv_usec * 1000);
                return new ColTimestamp(time, colType, colName);
            }
        }
        log.error("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a[{}]", (Object)colType.name());
        return null;
    }

    public static String row(Long num) {
        String startstr = String.format("[%s:0x%s]", num, Long.toHexString(num));
        return startstr;
    }

    public static String row(Integer num) {
        String startstr = String.format("[%s:0x%s]", num, Integer.toHexString(num));
        return startstr;
    }
}

