/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StatusVar {
    Q_FLAGS2_CODE("", 0),
    Q_SQL_MODE_CODE("", 1),
    Q_CATALOG("", 2),
    Q_AUTO_INCREMENT("", 3),
    Q_CHARSET_CODE("", 4),
    Q_TIME_ZONE_CODE("", 5),
    Q_CATALOG_NZ_CODE("", 6),
    Q_LC_TIME_NAMES_CODE("", 7),
    Q_CHARSET_DATABASE_CODE("", 8),
    Q_TABLE_MAP_FOR_UPDATE_CODE("", 9),
    Q_MASTER_DATA_WRITTEN_CODE("", 10),
    Q_INVOKERS("", 11),
    Q_UPDATED_DB_NAMES("", 12),
    Q_MICROSECONDS("", 13);

    private static final Logger log;
    private final String desc;
    private final byte value;

    private StatusVar(String desc, byte value) {
        this.desc = desc;
        this.value = value;
    }

    public static StatusVar get(byte val) {
        for (StatusVar statusVar : StatusVar.values()) {
            if (statusVar.getValue() != val) continue;
            return statusVar;
        }
        return null;
    }

    public static JSONArray parse(ByteUtil.AssitRead read) {
        JSONArray retary = new JSONArray();
        while (read.hasMore()) {
            StatusVar statusVar = StatusVar.get(read.readByte());
            JSONObject tempobj = statusVar.paseStatusVar(read);
            retary.add((Object)tempobj);
        }
        return retary;
    }

    public static JSONObject parseUpdatedDbNames(ByteUtil.AssitRead read) {
        JSONArray ary = StatusVar.parse(read);
        for (int i = 0; i < ary.size(); ++i) {
            JSONObject obj = ary.getJSONObject(i);
            if (!Q_UPDATED_DB_NAMES.name().equals(obj.get((Object)"statusVar"))) continue;
            return obj;
        }
        return null;
    }

    public JSONObject paseStatusVar(ByteUtil.AssitRead read) {
        JSONObject retobj = JSONUtil.packParams((Object[])new Object[]{"statusVar", this.name()});
        switch (this) {
            case Q_FLAGS2_CODE: {
                retobj.put("flags", (Object)ByteUtil.readLongL((byte[])read.readBytes(4)));
                break;
            }
            case Q_SQL_MODE_CODE: {
                retobj.put("sqlMode", (Object)ByteUtil.readLongL((byte[])read.readBytes(8)));
                break;
            }
            case Q_CATALOG: {
                ByteUtil.readIntL((byte[])read.readBytes(1));
                try {
                    retobj.put("catalogName", (Object)read.readStringEndNull());
                }
                catch (IOException e) {
                    log.error("\u89e3\u6790StatusVar[Q_CATALOG]\u51fa\u9519", (Throwable)e);
                }
                break;
            }
            case Q_AUTO_INCREMENT: {
                retobj.put("autoIncrementIncrement", (Object)ByteUtil.readIntL((byte[])read.readBytes(2)));
                retobj.put("autoIncrementOffset", (Object)ByteUtil.readIntL((byte[])read.readBytes(2)));
                break;
            }
            case Q_CHARSET_CODE: {
                retobj.put("characterSetClient", (Object)ByteUtil.readIntL((byte[])read.readBytes(2)));
                retobj.put("collationConnection", (Object)ByteUtil.readIntL((byte[])read.readBytes(2)));
                retobj.put("collationServer", (Object)ByteUtil.readIntL((byte[])read.readBytes(2)));
                break;
            }
            case Q_TIME_ZONE_CODE: {
                int length2 = ByteUtil.readIntL((byte[])read.readBytes(1));
                retobj.put("timeZone", (Object)ByteUtil.readString((byte[])read.readBytes(length2)));
                break;
            }
            case Q_CATALOG_NZ_CODE: {
                int length3 = ByteUtil.readIntL((byte[])read.readBytes(1));
                retobj.put("catalogName", (Object)ByteUtil.readString((byte[])read.readBytes(length3)));
                break;
            }
            case Q_LC_TIME_NAMES_CODE: {
                retobj.put("lcTimeNames", (Object)ByteUtil.readIntL((byte[])read.readBytes(2)));
                break;
            }
            case Q_CHARSET_DATABASE_CODE: {
                retobj.put("collationDatabase", (Object)ByteUtil.readIntL((byte[])read.readBytes(2)));
                break;
            }
            case Q_TABLE_MAP_FOR_UPDATE_CODE: {
                retobj.put("tableMap", (Object)ByteUtil.readLongL((byte[])read.readBytes(8)));
                break;
            }
            case Q_MASTER_DATA_WRITTEN_CODE: {
                retobj.put("value", (Object)ByteUtil.readLongL((byte[])read.readBytes(4)));
                break;
            }
            case Q_INVOKERS: {
                int userLength = ByteUtil.readIntL((byte[])read.readBytes(1));
                String user = ByteUtil.readString((byte[])read.readBytes(userLength));
                int hostLength = ByteUtil.readIntL((byte[])read.readBytes(1));
                String host = ByteUtil.readString((byte[])read.readBytes(hostLength));
                retobj.put("user", (Object)user);
                retobj.put("host", (Object)host);
                break;
            }
            case Q_UPDATED_DB_NAMES: {
                int accessedDbCount = ByteUtil.readIntL((byte[])read.readBytes(1));
                JSONArray accessedDbs = new JSONArray();
                if (accessedDbCount > 16) {
                    accessedDbCount = 254;
                } else {
                    for (int i = 0; i < accessedDbCount; ++i) {
                        try {
                            accessedDbs.add((Object)read.readStringEndNull());
                            continue;
                        }
                        catch (IOException e) {
                            log.error("\u89e3\u6790StatusVar[Q_UPDATED_DB_NAMES]\u51fa\u9519", (Throwable)e);
                        }
                    }
                }
                retobj.put("accessedDbCount", (Object)accessedDbCount);
                retobj.put("accessedDbs", (Object)accessedDbs);
                break;
            }
            case Q_MICROSECONDS: {
                retobj.put("startUsec", (Object)ByteUtil.readIntL((byte[])read.readBytes(3)));
                break;
            }
        }
        return retobj;
    }

    public String getDesc() {
        return this.desc;
    }

    public byte getValue() {
        return this.value;
    }

    static {
        log = LoggerFactory.getLogger(StatusVar.class);
    }
}

