/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.constant;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.wicp.tams.common.binlog.self.IEventRead;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.event.FormatDescription;
import net.wicp.tams.common.binlog.self.event.GtidEvent;
import net.wicp.tams.common.binlog.self.event.ParserNo;
import net.wicp.tams.common.binlog.self.event.RotateEvent;
import net.wicp.tams.common.binlog.self.event.StopEvent;
import net.wicp.tams.common.binlog.self.event.TableMapEvent;
import net.wicp.tams.common.binlog.self.event.rows.delete.DeleteRowsEventV1;
import net.wicp.tams.common.binlog.self.event.rows.delete.DeleteRowsEventV2;
import net.wicp.tams.common.binlog.self.event.rows.update.UpdateRowsEventV1;
import net.wicp.tams.common.binlog.self.event.rows.update.UpdateRowsEventV2;
import net.wicp.tams.common.binlog.self.event.rows.write.WriteRowsEventV1;
import net.wicp.tams.common.binlog.self.event.rows.write.WriteRowsEventV2;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public enum EventType {
    GTID_EVENT("gtid\u4e8b\u4ef6", 33, -1, "net.wicp.tams.commons.binlog.event.GtidEvent", true),
    TABLE_MAP_EVENT("\u8868\u7684\u63cf\u8ff0\u4e8b\u4ef6", 19, 18, "net.wicp.tams.commons.binlog.event.TableMapEvent", true),
    QUERY_EVENT("", 2, 1, "net.wicp.tams.commons.binlog.event.QueryEvent"),
    XID_EVENT("\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6", 16, 15, "net.wicp.tams.commons.binlog.event.XidEvent"),
    WRITE_ROWS_EVENTv1("", 23, 24, "net.wicp.tams.commons.binlog.event.rows.write.WriteRowsEventV1", true),
    UPDATE_ROWS_EVENTv1("", 24, 23, "net.wicp.tams.commons.binlog.event.rows.update.UpdateRowsEventV1", true),
    DELETE_ROWS_EVENTv1("", 25, 22, "net.wicp.tams.commons.binlog.event.rows.delete.DeleteRowsEventV1", true),
    STOP_EVENT("\u6587\u4ef6\u5df2\u5b8c\u6210\u4e8b\u4ef6", 3, 2, "net.wicp.tams.commons.binlog.event.StopEvent", true),
    ROTATE_EVENT("\u8df3\u8f6c\u4e8b\u4ef6", 4, 3, "net.wicp.tams.commons.binlog.event.RotateEvent", true),
    WRITE_ROWS_EVENTv2("", 30, 29, "net.wicp.tams.commons.binlog.event.rows.write.WriteRowsEventV2", true),
    UPDATE_ROWS_EVENTv2("", 31, 28, "net.wicp.tams.commons.binlog.event.rows.update.UpdateRowsEventV2", true),
    DELETE_ROWS_EVENTv2("", 32, 27, "net.wicp.tams.commons.binlog.event.rows.delete.DeleteRowsEventV2", true),
    FORMAT_DESCRIPTION_EVENT("", 15, 14, "net.wicp.tams.commons.binlog.event.FormatDescription", true),
    HEARTBEAT_EVENT("", 27, 26),
    UNKNOWN_EVENT("\u4e0d\u660e\u4e8b\u4ef6", 0),
    START_EVENT_V3("", 1, 0),
    INTVAR_EVENT("", 5, 4),
    LOAD_EVENT("", 6, 5),
    SLAVE_EVENT("", 7, 6),
    CREATE_FILE_EVENT("", 8, 7),
    APPEND_BLOCK_EVENT("", 9, 8),
    EXEC_LOAD_EVENT("", 10, 9),
    DELETE_FILE_EVENT("", 11, 10),
    NEW_LOAD_EVENT("", 12, 11),
    RAND_EVENT("", 13, 12),
    USER_VAR_EVENT("", 14, 13),
    BEGIN_LOAD_QUERY_EVENT("", 17, 16),
    EXECUTE_LOAD_QUERY_EVENT("", 18, 17),
    WRITE_ROWS_EVENTv0("", 20, 21),
    UPDATE_ROWS_EVENTv0("", 21, 20),
    DELETE_ROWS_EVENTv0("", 22, 19),
    INCIDENT_EVENT("", 26, 25),
    IGNORABLE_EVENT("", 28),
    ROWS_QUERY_EVENT("", 29),
    ANONYMOUS_GTID_EVENT("", 34),
    PREVIOUS_GTIDS_EVENT("", 35);

    private final String desc;
    private final int value;
    private final int formatIndex;
    private final String parser;
    private final boolean support;
    private final Map<Host, Integer> headerLengthMap = new HashMap<Host, Integer>();
    private static final Set<Host> hostset;
    public static EventType[] values;

    public IEventRead newInstNoReflect(EventBean eventBean) {
        if (this.getParser() != null) {
            switch (this) {
                case GTID_EVENT: {
                    return new GtidEvent(eventBean);
                }
                case TABLE_MAP_EVENT: {
                    return new TableMapEvent(eventBean);
                }
                case WRITE_ROWS_EVENTv1: {
                    return new WriteRowsEventV1(eventBean);
                }
                case UPDATE_ROWS_EVENTv1: {
                    return new UpdateRowsEventV1(eventBean);
                }
                case DELETE_ROWS_EVENTv1: {
                    return new DeleteRowsEventV1(eventBean);
                }
                case STOP_EVENT: {
                    return new StopEvent(eventBean);
                }
                case ROTATE_EVENT: {
                    return new RotateEvent(eventBean);
                }
                case WRITE_ROWS_EVENTv2: {
                    return new WriteRowsEventV2(eventBean);
                }
                case UPDATE_ROWS_EVENTv2: {
                    return new UpdateRowsEventV2(eventBean);
                }
                case DELETE_ROWS_EVENTv2: {
                    return new DeleteRowsEventV2(eventBean);
                }
                case FORMAT_DESCRIPTION_EVENT: {
                    return new FormatDescription(eventBean);
                }
            }
            return new ParserNo(eventBean);
        }
        return null;
    }

    public IEventRead newInst(EventBean eventBean) {
        if (this.getParser() != null) {
            try {
                IEventRead eventRead = (IEventRead)Class.forName(this.getParser()).getConstructor(EventBean.class).newInstance(new Object[]{this});
                return eventRead;
            }
            catch (Exception e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
        return null;
    }

    private EventType(String desc, int value, int formatIndex, String parser, boolean support) {
        this.desc = desc;
        this.value = value;
        this.formatIndex = formatIndex;
        this.parser = parser;
        this.support = support;
    }

    private EventType(String desc, int value, int formatIndex, String parser) {
        this.desc = desc;
        this.value = value;
        this.formatIndex = formatIndex;
        this.parser = parser;
        this.support = false;
    }

    private EventType(String desc, int value, int formatIndex) {
        this.desc = desc;
        this.value = value;
        this.formatIndex = formatIndex;
        this.parser = null;
        this.support = false;
    }

    private EventType(String desc, int value) {
        this.desc = desc;
        this.value = value;
        this.formatIndex = -1;
        this.parser = null;
        this.support = false;
    }

    public static EventType get(int val) {
        if (val >= EventType.UNKNOWN_EVENT.value & val <= EventType.PREVIOUS_GTIDS_EVENT.value) {
            return values[val];
        }
        return UNKNOWN_EVENT;
    }

    public static EventType get(String name) {
        for (EventType eventType : EventType.values()) {
            if (!eventType.name().equalsIgnoreCase(name)) continue;
            return eventType;
        }
        return null;
    }

    public static EventType[] orderFormat() {
        EventType[] retary = new EventType[30];
        for (EventType eventType : EventType.values()) {
            if (eventType.getFormatIndex() < 0) continue;
            retary[eventType.getFormatIndex()] = eventType;
        }
        return retary;
    }

    public static void setFormatDescription(JSONObject json) {
        for (String key : json.keySet()) {
            EventType eventType = EventType.get(key);
            if (eventType == null || eventType.getFormatIndex() < 0) continue;
            eventType.setPostHeaderLength(json.getIntValue(key));
        }
    }

    public static boolean isInit(Host host) {
        return hostset.contains(host);
    }

    public int getPostHeaderLength() {
        Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get((Object)new Host());
        Integer retobj = this.headerLengthMap.get(host);
        return host == null || retobj == null ? -1 : retobj;
    }

    public void setPostHeaderLength(int postHeaderLength) {
        Host host = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get((Object)new Host());
        if (host == null) {
            throw new IllegalAccessError("\u6ca1\u6709\u5f97\u5230\u4e3b\u673a\uff0c\u4e0d\u80fd\u505a\u8bbe\u7f6e");
        }
        hostset.add(host);
        this.headerLengthMap.put(host, postHeaderLength);
    }

    public String getDesc() {
        return this.desc;
    }

    public int getValue() {
        return this.value;
    }

    public int getFormatIndex() {
        return this.formatIndex;
    }

    public String getParser() {
        if (!this.support) {
            return null;
        }
        return this.parser;
    }

    public boolean isSupport() {
        return this.support;
    }

    static {
        hostset = new HashSet<Host>();
        values = new EventType[]{UNKNOWN_EVENT, START_EVENT_V3, QUERY_EVENT, STOP_EVENT, ROTATE_EVENT, INTVAR_EVENT, LOAD_EVENT, SLAVE_EVENT, CREATE_FILE_EVENT, APPEND_BLOCK_EVENT, EXEC_LOAD_EVENT, DELETE_FILE_EVENT, NEW_LOAD_EVENT, RAND_EVENT, USER_VAR_EVENT, FORMAT_DESCRIPTION_EVENT, XID_EVENT, BEGIN_LOAD_QUERY_EVENT, EXECUTE_LOAD_QUERY_EVENT, TABLE_MAP_EVENT, WRITE_ROWS_EVENTv0, UPDATE_ROWS_EVENTv0, DELETE_ROWS_EVENTv0, WRITE_ROWS_EVENTv1, UPDATE_ROWS_EVENTv1, DELETE_ROWS_EVENTv1, INCIDENT_EVENT, HEARTBEAT_EVENT, IGNORABLE_EVENT, ROWS_QUERY_EVENT, WRITE_ROWS_EVENTv2, UPDATE_ROWS_EVENTv2, DELETE_ROWS_EVENTv2, GTID_EVENT, ANONYMOUS_GTID_EVENT, PREVIOUS_GTIDS_EVENT};
    }
}

