/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.constant;

public enum ColumnType {
    DECIMAL("", 0),
    TINY("", 1, 0, 1),
    SHORT("", 2, 0, 2),
    LONG("", 3, 0, 4),
    FLOAT("", 4, 1, 4),
    DOUBLE("", 5, 1, 8),
    NULL("", 6),
    TIMESTAMP("", 7, 0),
    LONGLONG("", 8, 0, 8),
    INT24("", 9, 0, 4),
    DATE("", 10, 0),
    TIME("", 11),
    DATETIME("", 12, 0),
    YEAR("", 13),
    NEWDATE("", 14),
    VARCHAR("", 15, 2),
    BIT("", 16, 2),
    TIMESTAMP_V2("", 17, 1),
    DATETIME_V2("", 18, 1),
    TIME_V2("", 19, 1),
    NEWDECIMAL("", 246, 2),
    ENUM("", 247, 2),
    SET("", 248, 2),
    TINY_BLOB("", 249),
    MEDIUM_BLOB("", 250),
    LONG_BLOB("", 251),
    BLOB("", 252, 1),
    VAR_STRING("", 253, 2),
    STRING("", 254, 2),
    GEOMETRY("", 255, 1);

    private final String desc;
    private final int value;
    private final int metaLen;
    private final int colLen;
    public static ColumnType[] values1;
    public static ColumnType[] values2;

    public static ColumnType get(int val) {
        if (val <= ColumnType.TIME_V2.value) {
            return values1[val];
        }
        if (val >= ColumnType.NEWDECIMAL.value && val <= ColumnType.GEOMETRY.value) {
            return values2[val - ColumnType.NEWDECIMAL.value];
        }
        return null;
    }

    private ColumnType(String desc, int value, int metaLen, int colLen) {
        this.desc = desc;
        this.value = value;
        this.metaLen = metaLen;
        this.colLen = colLen;
    }

    private ColumnType(String desc, int value, int metaLen) {
        this.desc = desc;
        this.value = value;
        this.metaLen = metaLen;
        this.colLen = -1;
    }

    private ColumnType(String desc, int value) {
        this.desc = desc;
        this.value = value;
        this.metaLen = -1;
        this.colLen = -1;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getValue() {
        return this.value;
    }

    public int getMetaLen() {
        return this.metaLen;
    }

    public int getColLen() {
        return this.colLen;
    }

    static {
        values1 = new ColumnType[]{DECIMAL, TINY, SHORT, LONG, FLOAT, DOUBLE, NULL, TIMESTAMP, LONGLONG, INT24, DATE, TIME, DATETIME, YEAR, NEWDATE, VARCHAR, BIT, TIMESTAMP_V2, DATETIME_V2, TIME_V2};
        values2 = new ColumnType[]{NEWDECIMAL, ENUM, SET, TINY_BLOB, MEDIUM_BLOB, LONG_BLOB, BLOB, VAR_STRING, STRING, GEOMETRY};
    }
}

