/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.constant;

public enum CapabilityFlags {
    CLIENT_LONG_PASSWORD("", 1),
    CLIENT_FOUND_ROWS("", 2),
    CLIENT_LONG_FLAG("", 4),
    CLIENT_CONNECT_WITH_DB("", 8),
    CLIENT_NO_SCHEMA("", 16),
    CLIENT_COMPRESS("", 32),
    CLIENT_ODBC("", 64),
    CLIENT_LOCAL_FILES("", 128),
    CLIENT_IGNORE_SPACE("", 256),
    CLIENT_PROTOCOL_41("", 512),
    CLIENT_INTERACTIVE("", 1024),
    CLIENT_SSL("", 2048),
    CLIENT_IGNORE_SIGPIPE("", 4096),
    CLIENT_TRANSACTIONS("", 8192),
    CLIENT_RESERVED("", 16384),
    CLIENT_SECURE_CONNECTION("", 32768),
    CLIENT_MULTI_STATEMENTS("", 65536),
    CLIENT_MULTI_RESULTS("", 131072),
    CLIENT_PS_MULTI_RESULTS("", 262144),
    CLIENT_PLUGIN_AUTH("", 524288),
    CLIENT_CONNECT_ATTRS("", 0x100000),
    CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA("", 0x200000),
    CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS("", 0x400000),
    CLIENT_SESSION_TRACK("", 0x800000),
    CLIENT_DEPRECATE_EOF("", 0x1000000);

    private final String desc;
    private final int value;

    private CapabilityFlags(String desc, int value) {
        this.desc = desc;
        this.value = value;
    }

    public static CapabilityFlags get(int val) {
        for (CapabilityFlags capabilityFlags : CapabilityFlags.values()) {
            if (capabilityFlags.getValue() != val) continue;
            return capabilityFlags;
        }
        return null;
    }

    public static int defaultCapability() {
        return CLIENT_LONG_FLAG.getValue() | CLIENT_PROTOCOL_41.getValue() | CLIENT_SECURE_CONNECTION.getValue();
    }

    public String getDesc() {
        return this.desc;
    }

    public int getValue() {
        return this.value;
    }
}

