/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.callback.column;

import com.alibaba.fastjson.annotation.JSONField;
import java.sql.Timestamp;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.constant.DateFormatCase;

public class ColTimestamp
implements ICol<Timestamp> {
    private static final long serialVersionUID = 1L;
    private Timestamp value;
    private ColumnType colType;
    private String colName;

    @Override
    @JSONField(serialize=false)
    public String getClient() {
        return DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(this.value);
    }

    public ColTimestamp(Timestamp value, ColumnType colType, String colName) {
        this.value = value;
        this.colType = colType;
        this.colName = colName;
    }

    public static ColTimestampBuilder builder() {
        return new ColTimestampBuilder();
    }

    @Override
    public Timestamp getValue() {
        return this.value;
    }

    @Override
    public ColumnType getColType() {
        return this.colType;
    }

    @Override
    public String getColName() {
        return this.colName;
    }

    public void setValue(Timestamp value) {
        this.value = value;
    }

    public void setColType(ColumnType colType) {
        this.colType = colType;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColTimestamp)) {
            return false;
        }
        ColTimestamp other = (ColTimestamp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Timestamp this$value = this.getValue();
        Timestamp other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        ColumnType this$colType = this.getColType();
        ColumnType other$colType = other.getColType();
        if (this$colType == null ? other$colType != null : !((Object)((Object)this$colType)).equals((Object)other$colType)) {
            return false;
        }
        String this$colName = this.getColName();
        String other$colName = other.getColName();
        return !(this$colName == null ? other$colName != null : !this$colName.equals(other$colName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColTimestamp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Timestamp $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        ColumnType $colType = this.getColType();
        result = result * 59 + ($colType == null ? 43 : ((Object)((Object)$colType)).hashCode());
        String $colName = this.getColName();
        result = result * 59 + ($colName == null ? 43 : $colName.hashCode());
        return result;
    }

    public String toString() {
        return "ColTimestamp(value=" + this.getValue() + ", colType=" + (Object)((Object)this.getColType()) + ", colName=" + this.getColName() + ")";
    }

    public static class ColTimestampBuilder {
        private Timestamp value;
        private ColumnType colType;
        private String colName;

        ColTimestampBuilder() {
        }

        public ColTimestampBuilder value(Timestamp value) {
            this.value = value;
            return this;
        }

        public ColTimestampBuilder colType(ColumnType colType) {
            this.colType = colType;
            return this;
        }

        public ColTimestampBuilder colName(String colName) {
            this.colName = colName;
            return this;
        }

        public ColTimestamp build() {
            return new ColTimestamp(this.value, this.colType, this.colName);
        }

        public String toString() {
            return "ColTimestamp.ColTimestampBuilder(value=" + this.value + ", colType=" + (Object)((Object)this.colType) + ", colName=" + this.colName + ")";
        }
    }
}

