/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.bean;

import com.alibaba.fastjson.annotation.JSONField;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.JdbcUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.bean.Pos;
import net.wicp.tams.common.binlog.self.constant.SenderEnum;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.constant.dic.YesOrNo;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    private String id;
    private String ip;
    private int clientId;
    private int port;
    private String dbinst;
    private String user;
    private String pwd;
    private String defaultDb;
    private String dbPattern;
    private String tbPattern;
    private String senderOther;
    private String senderEnum;
    private Map<String, String> params;
    private String remark;
    private YesOrNo multiThread;
    private int threadNum;
    private int querySize;
    private int tableNum;
    private String splitKey;
    private List<ISender> senders;

    @JSONField(serialize=false)
    public List<ISender> getSenders() {
        this.senders = new ArrayList<ISender>();
        if (StringUtil.isNull((Object)this.senderEnum) || "no".equals(this.senderEnum) && StringUtil.isNull((Object)this.senderOther)) {
            return this.senders;
        }
        String senderClass = "";
        senderClass = "no".equals(this.senderEnum) ? this.senderOther : this.senderEnum;
        if (CollectionUtils.isEmpty(this.senders) && StringUtil.isNotNull((Object)senderClass)) {
            String[] senderAry = senderClass.split(",");
            this.senders = new ArrayList<ISender>();
            HashMap<String, String> paramsInput = new HashMap<String, String>();
            if (this.params != null) {
                paramsInput.putAll(this.params);
            }
            paramsInput.put("_multiThread", this.multiThread == null ? "no" : this.multiThread.name());
            paramsInput.put("_threadNum", String.valueOf(this.threadNum));
            paramsInput.put("_querySize", String.valueOf(this.querySize));
            paramsInput.put("_splitKey", this.splitKey);
            paramsInput.put("_tableNum", String.valueOf(this.tableNum));
            for (String senderStr : senderAry) {
                try {
                    SenderEnum temp = SenderEnum.get(senderStr);
                    ISender sender = (ISender)Class.forName(temp == null ? senderStr : temp.getValue()).newInstance();
                    sender.init(log, this.id, paramsInput);
                    this.senders.add(sender);
                }
                catch (Exception e) {
                    log.error(String.format("\u6dfb\u52a0sender\uff1a[%s]\u9519\u8bef", senderStr), (Throwable)e);
                }
            }
        }
        return this.senders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSONField(serialize=false)
    public Pos getMastStatus() {
        String url = StringUtil.isNull((Object)this.defaultDb) ? String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", this.ip, this.port) : String.format("jdbc:mysql://%s:%s/%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", this.ip, this.port, this.defaultDb);
        Connection conn = JdbcUtil.getConnection((String)"com.mysql.jdbc.Driver", (String)url, (String)this.user, (String)this.pwd);
        ResultSet rs = JdbcUtil.querySql((Connection)conn, (String)"show master status");
        try {
            if (rs.next()) {
                String filename = rs.getString(1);
                long pos = rs.getLong(2);
                Pos ret = new Pos();
                ret.setFileName(filename);
                ret.setPos(pos);
                if (rs.getMetaData().getColumnCount() >= 5) {
                    String gtidStr = rs.getString(5);
                    ret.setGtids(gtidStr.replace("/n", ""));
                }
                if ((rs = JdbcUtil.querySql((Connection)conn, (String)"show variables like 'server_id'")).next()) {
                    long masterServerId = rs.getLong(2);
                    ret.setMasterServerId(masterServerId);
                }
                Pos pos2 = ret;
                return pos2;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.close();
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void addSender(ISender sender) {
        if (this.senders == null) {
            this.senders = new ArrayList<ISender>();
        }
        this.senders.add(sender);
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getPort() {
        return this.port;
    }

    public String getDbinst() {
        return this.dbinst;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getDefaultDb() {
        return this.defaultDb;
    }

    public String getDbPattern() {
        return this.dbPattern;
    }

    public String getTbPattern() {
        return this.tbPattern;
    }

    public String getSenderOther() {
        return this.senderOther;
    }

    public String getSenderEnum() {
        return this.senderEnum;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getRemark() {
        return this.remark;
    }

    public YesOrNo getMultiThread() {
        return this.multiThread;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public int getQuerySize() {
        return this.querySize;
    }

    public int getTableNum() {
        return this.tableNum;
    }

    public String getSplitKey() {
        return this.splitKey;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDbinst(String dbinst) {
        this.dbinst = dbinst;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setDefaultDb(String defaultDb) {
        this.defaultDb = defaultDb;
    }

    public void setDbPattern(String dbPattern) {
        this.dbPattern = dbPattern;
    }

    public void setTbPattern(String tbPattern) {
        this.tbPattern = tbPattern;
    }

    public void setSenderOther(String senderOther) {
        this.senderOther = senderOther;
    }

    public void setSenderEnum(String senderEnum) {
        this.senderEnum = senderEnum;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setMultiThread(YesOrNo multiThread) {
        this.multiThread = multiThread;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public void setQuerySize(int querySize) {
        this.querySize = querySize;
    }

    public void setTableNum(int tableNum) {
        this.tableNum = tableNum;
    }

    public void setSplitKey(String splitKey) {
        this.splitKey = splitKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.getClientId() != other.getClientId()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$dbinst = this.getDbinst();
        String other$dbinst = other.getDbinst();
        if (this$dbinst == null ? other$dbinst != null : !this$dbinst.equals(other$dbinst)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$pwd = this.getPwd();
        String other$pwd = other.getPwd();
        if (this$pwd == null ? other$pwd != null : !this$pwd.equals(other$pwd)) {
            return false;
        }
        String this$defaultDb = this.getDefaultDb();
        String other$defaultDb = other.getDefaultDb();
        if (this$defaultDb == null ? other$defaultDb != null : !this$defaultDb.equals(other$defaultDb)) {
            return false;
        }
        String this$dbPattern = this.getDbPattern();
        String other$dbPattern = other.getDbPattern();
        if (this$dbPattern == null ? other$dbPattern != null : !this$dbPattern.equals(other$dbPattern)) {
            return false;
        }
        String this$tbPattern = this.getTbPattern();
        String other$tbPattern = other.getTbPattern();
        if (this$tbPattern == null ? other$tbPattern != null : !this$tbPattern.equals(other$tbPattern)) {
            return false;
        }
        String this$senderOther = this.getSenderOther();
        String other$senderOther = other.getSenderOther();
        if (this$senderOther == null ? other$senderOther != null : !this$senderOther.equals(other$senderOther)) {
            return false;
        }
        String this$senderEnum = this.getSenderEnum();
        String other$senderEnum = other.getSenderEnum();
        if (this$senderEnum == null ? other$senderEnum != null : !this$senderEnum.equals(other$senderEnum)) {
            return false;
        }
        Map<String, String> this$params = this.getParams();
        Map<String, String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        YesOrNo this$multiThread = this.getMultiThread();
        YesOrNo other$multiThread = other.getMultiThread();
        if (this$multiThread == null ? other$multiThread != null : !this$multiThread.equals(other$multiThread)) {
            return false;
        }
        if (this.getThreadNum() != other.getThreadNum()) {
            return false;
        }
        if (this.getQuerySize() != other.getQuerySize()) {
            return false;
        }
        if (this.getTableNum() != other.getTableNum()) {
            return false;
        }
        String this$splitKey = this.getSplitKey();
        String other$splitKey = other.getSplitKey();
        if (this$splitKey == null ? other$splitKey != null : !this$splitKey.equals(other$splitKey)) {
            return false;
        }
        List<ISender> this$senders = this.getSenders();
        List<ISender> other$senders = other.getSenders();
        return !(this$senders == null ? other$senders != null : !((Object)this$senders).equals(other$senders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + this.getClientId();
        result = result * 59 + this.getPort();
        String $dbinst = this.getDbinst();
        result = result * 59 + ($dbinst == null ? 43 : $dbinst.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $pwd = this.getPwd();
        result = result * 59 + ($pwd == null ? 43 : $pwd.hashCode());
        String $defaultDb = this.getDefaultDb();
        result = result * 59 + ($defaultDb == null ? 43 : $defaultDb.hashCode());
        String $dbPattern = this.getDbPattern();
        result = result * 59 + ($dbPattern == null ? 43 : $dbPattern.hashCode());
        String $tbPattern = this.getTbPattern();
        result = result * 59 + ($tbPattern == null ? 43 : $tbPattern.hashCode());
        String $senderOther = this.getSenderOther();
        result = result * 59 + ($senderOther == null ? 43 : $senderOther.hashCode());
        String $senderEnum = this.getSenderEnum();
        result = result * 59 + ($senderEnum == null ? 43 : $senderEnum.hashCode());
        Map<String, String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        YesOrNo $multiThread = this.getMultiThread();
        result = result * 59 + ($multiThread == null ? 43 : $multiThread.hashCode());
        result = result * 59 + this.getThreadNum();
        result = result * 59 + this.getQuerySize();
        result = result * 59 + this.getTableNum();
        String $splitKey = this.getSplitKey();
        result = result * 59 + ($splitKey == null ? 43 : $splitKey.hashCode());
        List<ISender> $senders = this.getSenders();
        result = result * 59 + ($senders == null ? 43 : ((Object)$senders).hashCode());
        return result;
    }

    public String toString() {
        return "Task(id=" + this.getId() + ", ip=" + this.getIp() + ", clientId=" + this.getClientId() + ", port=" + this.getPort() + ", dbinst=" + this.getDbinst() + ", user=" + this.getUser() + ", pwd=" + this.getPwd() + ", defaultDb=" + this.getDefaultDb() + ", dbPattern=" + this.getDbPattern() + ", tbPattern=" + this.getTbPattern() + ", senderOther=" + this.getSenderOther() + ", senderEnum=" + this.getSenderEnum() + ", params=" + this.getParams() + ", remark=" + this.getRemark() + ", multiThread=" + this.getMultiThread() + ", threadNum=" + this.getThreadNum() + ", querySize=" + this.getQuerySize() + ", tableNum=" + this.getTableNum() + ", splitKey=" + this.getSplitKey() + ", senders=" + this.getSenders() + ")";
    }

    private void setSenders(List<ISender> senders) {
        this.senders = senders;
    }
}

