/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.bean;

import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.binlog.self.bean.SendObj;
import net.wicp.tams.common.binlog.self.bean.SendRow;
import net.wicp.tams.common.binlog.self.bean.TableMapBean;
import net.wicp.tams.common.binlog.self.callback.ICol;
import net.wicp.tams.common.binlog.self.proto.SendObjProto;
import net.wicp.tams.common.constant.OptType;
import org.apache.commons.collections.CollectionUtils;

public class SendBean {
    private TableMapBean tableMapBean;
    private int columnCount;
    private OptType optType;
    private long timestamp;
    private String gtid;
    private List<SendRow> rows;

    public SendObj toSendObj() {
        SendObj retobj = SendObj.builder().optType(this.optType).rows(this.rows).gtid(this.gtid).db(this.tableMapBean.getSchemaName()).tb(this.tableMapBean.getTableName()).build();
        return retobj;
    }

    public SendObjProto.SendObj toProto() {
        SendObjProto.SendObj.Builder sendobj = SendObjProto.SendObj.newBuilder();
        sendobj.setOptType(Enum.valueOf(SendObjProto.SendObj.OptType.class, this.optType.name()));
        ArrayList<SendObjProto.SendRow> protoRows = new ArrayList<SendObjProto.SendRow>();
        for (SendRow ele : this.rows) {
            SendObjProto.SendRow.Builder insertemp = SendObjProto.SendRow.newBuilder();
            this.convertRow(ele, true, insertemp);
            this.convertRow(ele, false, insertemp);
            protoRows.add(insertemp.build());
        }
        sendobj.addAllRows(protoRows);
        sendobj.setGtid(this.gtid);
        sendobj.setDb(this.tableMapBean.getSchemaName());
        sendobj.setTb(this.tableMapBean.getTableName());
        SendObjProto.SendObj ret = sendobj.build();
        return ret;
    }

    private void convertRow(SendRow ele, boolean isBefore, SendObjProto.SendRow.Builder insertemp) {
        List<ICol> templist;
        List<ICol> list = templist = isBefore ? ele.getBefore() : ele.getAfter();
        if (CollectionUtils.isNotEmpty(templist)) {
            ArrayList<SendObjProto.Col> tempInsert = new ArrayList<SendObjProto.Col>();
            for (ICol iCol : templist) {
                SendObjProto.Col.Builder colbuilder = SendObjProto.Col.newBuilder();
                colbuilder.setColName(iCol.getColName());
                colbuilder.setColType(Enum.valueOf(SendObjProto.Col.ColumnType.class, iCol.getColType().name()));
                colbuilder.setValue(iCol.getClient());
                tempInsert.add(colbuilder.build());
            }
            if (isBefore) {
                insertemp.addAllBefore(tempInsert);
            } else {
                insertemp.addAllAfter(tempInsert);
            }
        }
    }

    SendBean(TableMapBean tableMapBean, int columnCount, OptType optType, long timestamp, String gtid, List<SendRow> rows) {
        this.tableMapBean = tableMapBean;
        this.columnCount = columnCount;
        this.optType = optType;
        this.timestamp = timestamp;
        this.gtid = gtid;
        this.rows = rows;
    }

    public static SendBeanBuilder builder() {
        return new SendBeanBuilder();
    }

    public TableMapBean getTableMapBean() {
        return this.tableMapBean;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public OptType getOptType() {
        return this.optType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getGtid() {
        return this.gtid;
    }

    public List<SendRow> getRows() {
        return this.rows;
    }

    public void setTableMapBean(TableMapBean tableMapBean) {
        this.tableMapBean = tableMapBean;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void setOptType(OptType optType) {
        this.optType = optType;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setGtid(String gtid) {
        this.gtid = gtid;
    }

    public void setRows(List<SendRow> rows) {
        this.rows = rows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendBean)) {
            return false;
        }
        SendBean other = (SendBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableMapBean this$tableMapBean = this.getTableMapBean();
        TableMapBean other$tableMapBean = other.getTableMapBean();
        if (this$tableMapBean == null ? other$tableMapBean != null : !((Object)this$tableMapBean).equals(other$tableMapBean)) {
            return false;
        }
        if (this.getColumnCount() != other.getColumnCount()) {
            return false;
        }
        OptType this$optType = this.getOptType();
        OptType other$optType = other.getOptType();
        if (this$optType == null ? other$optType != null : !this$optType.equals(other$optType)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$gtid = this.getGtid();
        String other$gtid = other.getGtid();
        if (this$gtid == null ? other$gtid != null : !this$gtid.equals(other$gtid)) {
            return false;
        }
        List<SendRow> this$rows = this.getRows();
        List<SendRow> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableMapBean $tableMapBean = this.getTableMapBean();
        result = result * 59 + ($tableMapBean == null ? 43 : ((Object)$tableMapBean).hashCode());
        result = result * 59 + this.getColumnCount();
        OptType $optType = this.getOptType();
        result = result * 59 + ($optType == null ? 43 : $optType.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $gtid = this.getGtid();
        result = result * 59 + ($gtid == null ? 43 : $gtid.hashCode());
        List<SendRow> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    public String toString() {
        return "SendBean(tableMapBean=" + this.getTableMapBean() + ", columnCount=" + this.getColumnCount() + ", optType=" + this.getOptType() + ", timestamp=" + this.getTimestamp() + ", gtid=" + this.getGtid() + ", rows=" + this.getRows() + ")";
    }

    public static class SendBeanBuilder {
        private TableMapBean tableMapBean;
        private int columnCount;
        private OptType optType;
        private long timestamp;
        private String gtid;
        private List<SendRow> rows;

        SendBeanBuilder() {
        }

        public SendBeanBuilder tableMapBean(TableMapBean tableMapBean) {
            this.tableMapBean = tableMapBean;
            return this;
        }

        public SendBeanBuilder columnCount(int columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public SendBeanBuilder optType(OptType optType) {
            this.optType = optType;
            return this;
        }

        public SendBeanBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SendBeanBuilder gtid(String gtid) {
            this.gtid = gtid;
            return this;
        }

        public SendBeanBuilder rows(List<SendRow> rows) {
            this.rows = rows;
            return this;
        }

        public SendBean build() {
            return new SendBean(this.tableMapBean, this.columnCount, this.optType, this.timestamp, this.gtid, this.rows);
        }

        public String toString() {
            return "SendBean.SendBeanBuilder(tableMapBean=" + this.tableMapBean + ", columnCount=" + this.columnCount + ", optType=" + this.optType + ", timestamp=" + this.timestamp + ", gtid=" + this.gtid + ", rows=" + this.rows + ")";
        }
    }
}

