/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.bean;

import java.io.IOException;
import java.io.InputStream;
import net.wicp.tams.common.binlog.self.LogBuffer;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.constant.Checksum;
import net.wicp.tams.common.io.InputStreamAssit;

public class PacketBean {
    private int sequence;
    private LogBuffer body;
    private byte packetMarker;
    private EventBean eventBean;

    public int getLength() {
        return this.body.capacity() - 1;
    }

    public static PacketBean buildBean(InputStream in) throws IOException {
        InputStreamAssit isAssit = new InputStreamAssit(in);
        int length = isAssit.readInt(3);
        int sequence = isAssit.readInt(1);
        byte[] body = isAssit.readBytes(length);
        byte packetMarker = body[0];
        return PacketBean.builder().sequence(sequence).body(new LogBuffer(body, 0, body.length)).packetMarker(packetMarker).build();
    }

    public static PacketBean buildEventBean(InputStream in, String fileName, String gtids, Checksum checksum) throws IOException {
        InputStreamAssit isAssit = new InputStreamAssit(in);
        int length = isAssit.readInt(3);
        int sequence = isAssit.readInt(1);
        byte[] body = isAssit.readBytes(length);
        if (length == 0) {
            throw new RuntimeException(String.format("\u63a5\u51fa\u7684socket\u51fa\u73b0\u5f02\u5e38\uff0c\u670d\u52a1\u5c06\u9000\u51fa.fileName:%s,gtids:%s", fileName, gtids));
        }
        byte packetMarker = body[0];
        LogBuffer logBuffer = new LogBuffer(body, 0, body.length - checksum.getByteNum());
        EventBean eventBean = new EventBean(logBuffer);
        eventBean.setFileName(fileName);
        eventBean.setGtids(gtids);
        eventBean.setChecksum(checksum);
        return PacketBean.builder().sequence(sequence).body(logBuffer).packetMarker(packetMarker).eventBean(eventBean).build();
    }

    PacketBean(int sequence, LogBuffer body, byte packetMarker, EventBean eventBean) {
        this.sequence = sequence;
        this.body = body;
        this.packetMarker = packetMarker;
        this.eventBean = eventBean;
    }

    public static PacketBeanBuilder builder() {
        return new PacketBeanBuilder();
    }

    public int getSequence() {
        return this.sequence;
    }

    public LogBuffer getBody() {
        return this.body;
    }

    public byte getPacketMarker() {
        return this.packetMarker;
    }

    public EventBean getEventBean() {
        return this.eventBean;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public void setBody(LogBuffer body) {
        this.body = body;
    }

    public void setPacketMarker(byte packetMarker) {
        this.packetMarker = packetMarker;
    }

    public void setEventBean(EventBean eventBean) {
        this.eventBean = eventBean;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketBean)) {
            return false;
        }
        PacketBean other = (PacketBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        LogBuffer this$body = this.getBody();
        LogBuffer other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        if (this.getPacketMarker() != other.getPacketMarker()) {
            return false;
        }
        EventBean this$eventBean = this.getEventBean();
        EventBean other$eventBean = other.getEventBean();
        return !(this$eventBean == null ? other$eventBean != null : !((Object)this$eventBean).equals(other$eventBean));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        LogBuffer $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        result = result * 59 + this.getPacketMarker();
        EventBean $eventBean = this.getEventBean();
        result = result * 59 + ($eventBean == null ? 43 : ((Object)$eventBean).hashCode());
        return result;
    }

    public String toString() {
        return "PacketBean(sequence=" + this.getSequence() + ", body=" + this.getBody() + ", packetMarker=" + this.getPacketMarker() + ", eventBean=" + this.getEventBean() + ")";
    }

    public static class PacketBeanBuilder {
        private int sequence;
        private LogBuffer body;
        private byte packetMarker;
        private EventBean eventBean;

        PacketBeanBuilder() {
        }

        public PacketBeanBuilder sequence(int sequence) {
            this.sequence = sequence;
            return this;
        }

        public PacketBeanBuilder body(LogBuffer body) {
            this.body = body;
            return this;
        }

        public PacketBeanBuilder packetMarker(byte packetMarker) {
            this.packetMarker = packetMarker;
            return this;
        }

        public PacketBeanBuilder eventBean(EventBean eventBean) {
            this.eventBean = eventBean;
            return this;
        }

        public PacketBean build() {
            return new PacketBean(this.sequence, this.body, this.packetMarker, this.eventBean);
        }

        public String toString() {
            return "PacketBean.PacketBeanBuilder(sequence=" + this.sequence + ", body=" + this.body + ", packetMarker=" + this.packetMarker + ", eventBean=" + this.eventBean + ")";
        }
    }
}

