/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.apiext.JdbcUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.bean.TableMapBean;
import net.wicp.tams.common.constant.StrPattern;
import org.apache.commons.collections.CollectionUtils;

public class Host
implements Comparable<Host> {
    public static final String preVar = "zorro-host";
    private String hostName;
    private String hostIp;
    private int port;
    private final String charsetName = "UTF-8";
    private String user;
    private String pwd;
    private String defaultDb;
    private String dbPattern;
    private String tbPattern;
    private final Map<String, List<String>> colsMap;
    private final Map<Long, TableMapBean> tbmaps = new HashMap<Long, TableMapBean>();

    public void addTableMapBean(TableMapBean tableMapBean) {
        if (tableMapBean == null) {
            return;
        }
        this.tbmaps.put(tableMapBean.getTableId(), tableMapBean);
    }

    public boolean checkTable(String schemaName, String tableName) {
        boolean ret;
        if (StringUtil.isNotNull((Object)this.dbPattern) && !(ret = StrPattern.checkStrFormat((String)this.dbPattern, (String)schemaName))) {
            return false;
        }
        return !StringUtil.isNotNull((Object)this.tbPattern) || (ret = StrPattern.checkStrFormat((String)this.tbPattern, (String)tableName));
    }

    public TableMapBean findTableMapBean(Long tabId) {
        return this.tbmaps.get(tabId);
    }

    public boolean containsTabId(Long tabId) {
        return this.tbmaps.containsKey(tabId);
    }

    public Host() {
        this.colsMap = new HashMap<String, List<String>>();
    }

    public Host(String hostName, String hostIp, int port, String user, String pwd, String defaultDb, String dbPattern, String tbPattern, Map<String, List<String>> colsMap) {
        this.hostName = hostName;
        this.hostIp = hostIp;
        this.port = port;
        this.user = user;
        this.pwd = pwd;
        this.defaultDb = defaultDb;
        this.colsMap = colsMap;
        this.dbPattern = dbPattern;
        this.tbPattern = tbPattern;
    }

    public boolean equals(Object obj) {
        Host temp = (Host)obj;
        return this.hostIp.equals(temp.getHostIp()) && this.port == temp.getPort();
    }

    public int hashCode() {
        return this.hostIp.hashCode() * 37 + this.port;
    }

    @Override
    public int compareTo(Host o) {
        String[] ips1 = this.hostIp.split(".");
        String[] ips2 = o.getHostIp().split(".");
        for (int i = 0; i < 4; ++i) {
            int si2;
            int si1 = Integer.parseInt(ips1[i]);
            if (si1 == (si2 = Integer.parseInt(ips2[i]))) continue;
            return si1 - si2;
        }
        return this.port - o.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCols(String schemaName, String tableName) {
        String key = this.findKey(schemaName, tableName);
        if (!this.colsMap.containsKey(key)) {
            ArrayList<String> ret = new ArrayList<String>();
            String url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", this.hostIp, this.port);
            Connection conn = JdbcUtil.getConnection((String)"com.mysql.jdbc.Driver", (String)url, (String)this.user, (String)this.pwd);
            try {
                PreparedStatement prep = conn.prepareStatement("select   column_name   from  information_schema.columns  where  table_schema=? and table_name=?");
                JdbcUtil.setPreParam((PreparedStatement)prep, (Object[])new Object[]{schemaName, tableName});
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    ret.add(rs.getString(1));
                }
                if (CollectionUtils.isNotEmpty(ret)) {
                    this.colsMap.put(key, ret);
                }
                rs.close();
            }
            catch (SQLException e) {
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return this.colsMap.get(key);
    }

    public void addCols(Properties cols) {
        if (cols == null || cols.size() == 0) {
            return;
        }
        for (Object obj : cols.keySet()) {
            String key = String.valueOf(obj);
            String[] input = key.split("\\.");
            String keytrue = this.findKey(input[0], input[1]);
            String val = cols.getProperty(key);
            this.colsMap.put(keytrue, Arrays.asList(val.split(",")));
        }
    }

    public void delCols(String schemaName, String tableName) {
        String key = this.findKey(schemaName, tableName);
        this.colsMap.remove(key);
    }

    private String findKey(String schemaName, String tableName) {
        String key_db = schemaName;
        if (StrPattern.db_split.checkStrFormat(schemaName)) {
            int lastint = schemaName.lastIndexOf("_");
            key_db = schemaName.substring(0, lastint + 1) + "00";
        }
        String key_tb = tableName;
        if (StrPattern.tb_split.checkStrFormat(tableName)) {
            int lastint = tableName.lastIndexOf("_");
            key_tb = tableName.substring(0, lastint + 1) + "0000";
        }
        String key = String.format("%s.%s", key_db, key_tb);
        return key;
    }

    public static HostBuilder builder() {
        return new HostBuilder();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public int getPort() {
        return this.port;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getDefaultDb() {
        return this.defaultDb;
    }

    public String getDbPattern() {
        return this.dbPattern;
    }

    public String getTbPattern() {
        return this.tbPattern;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setDefaultDb(String defaultDb) {
        this.defaultDb = defaultDb;
    }

    public void setDbPattern(String dbPattern) {
        this.dbPattern = dbPattern;
    }

    public void setTbPattern(String tbPattern) {
        this.tbPattern = tbPattern;
    }

    public String toString() {
        return "Host(hostName=" + this.getHostName() + ", hostIp=" + this.getHostIp() + ", port=" + this.getPort() + ", charsetName=" + this.getCharsetName() + ", user=" + this.getUser() + ", pwd=" + this.getPwd() + ", defaultDb=" + this.getDefaultDb() + ", dbPattern=" + this.getDbPattern() + ", tbPattern=" + this.getTbPattern() + ", colsMap=" + this.getColsMap() + ", tbmaps=" + this.getTbmaps() + ")";
    }

    private Map<String, List<String>> getColsMap() {
        return this.colsMap;
    }

    private Map<Long, TableMapBean> getTbmaps() {
        return this.tbmaps;
    }

    public static class HostBuilder {
        private String hostName;
        private String hostIp;
        private int port;
        private String user;
        private String pwd;
        private String defaultDb;
        private String dbPattern;
        private String tbPattern;
        private Map<String, List<String>> colsMap;

        HostBuilder() {
        }

        public HostBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public HostBuilder hostIp(String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        public HostBuilder port(int port) {
            this.port = port;
            return this;
        }

        public HostBuilder user(String user) {
            this.user = user;
            return this;
        }

        public HostBuilder pwd(String pwd) {
            this.pwd = pwd;
            return this;
        }

        public HostBuilder defaultDb(String defaultDb) {
            this.defaultDb = defaultDb;
            return this;
        }

        public HostBuilder dbPattern(String dbPattern) {
            this.dbPattern = dbPattern;
            return this;
        }

        public HostBuilder tbPattern(String tbPattern) {
            this.tbPattern = tbPattern;
            return this;
        }

        public HostBuilder colsMap(Map<String, List<String>> colsMap) {
            this.colsMap = colsMap;
            return this;
        }

        public Host build() {
            return new Host(this.hostName, this.hostIp, this.port, this.user, this.pwd, this.defaultDb, this.dbPattern, this.tbPattern, this.colsMap);
        }

        public String toString() {
            return "Host.HostBuilder(hostName=" + this.hostName + ", hostIp=" + this.hostIp + ", port=" + this.port + ", user=" + this.user + ", pwd=" + this.pwd + ", defaultDb=" + this.defaultDb + ", dbPattern=" + this.dbPattern + ", tbPattern=" + this.tbPattern + ", colsMap=" + this.colsMap + ")";
        }
    }
}

