/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self.bean;

import net.wicp.tams.common.binlog.self.IEventRead;
import net.wicp.tams.common.binlog.self.LogBuffer;
import net.wicp.tams.common.binlog.self.bean.EventHeader;
import net.wicp.tams.common.binlog.self.constant.Checksum;
import net.wicp.tams.common.binlog.self.constant.EventFlag;
import net.wicp.tams.common.binlog.self.constant.EventType;

public class EventBean {
    private EventHeader head;
    private LogBuffer body;
    private IEventRead eventRead;
    private long beginHead;
    private String fileName;
    private String gtids;
    private Checksum checksum;

    public IEventRead getEventRead() {
        if (this.head == null || this.head.getEventType() == null) {
            return null;
        }
        if (this.eventRead == null) {
            this.eventRead = this.head.getEventType().newInstNoReflect(this);
        }
        return this.eventRead;
    }

    public long getBeginHead() {
        if (this.beginHead == 0L) {
            this.beginHead = this.head.getNextEventPos() - this.head.getEventSize();
        }
        return this.beginHead;
    }

    public long getBeginBody() {
        return this.getBeginHead() + 19L;
    }

    public EventBean(EventHeader head, byte[] body) {
        this.head = head;
        this.body = new LogBuffer(body, 0, body.length);
    }

    public EventBean(LogBuffer logBuffer) {
        logBuffer.forward(1);
        long timestamp = logBuffer.getInt32();
        EventType eventType = EventType.get(logBuffer.getUint8());
        long serverId = logBuffer.getInt32();
        long eventSize = logBuffer.getInt32();
        long nextEventPos = logBuffer.getInt32();
        EventFlag eventFlag = EventFlag.get(logBuffer.getUint16());
        this.body = logBuffer;
        this.head = EventHeader.builder().timestamp(timestamp).eventType(eventType).serverId(serverId).eventSize(eventSize).nextEventPos(nextEventPos).eventFlag(eventFlag).build();
    }

    public EventHeader getHead() {
        return this.head;
    }

    public LogBuffer getBody() {
        return this.body;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getGtids() {
        return this.gtids;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setHead(EventHeader head) {
        this.head = head;
    }

    public void setBody(LogBuffer body) {
        this.body = body;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setGtids(String gtids) {
        this.gtids = gtids;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventBean)) {
            return false;
        }
        EventBean other = (EventBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventHeader this$head = this.getHead();
        EventHeader other$head = other.getHead();
        if (this$head == null ? other$head != null : !((Object)this$head).equals(other$head)) {
            return false;
        }
        LogBuffer this$body = this.getBody();
        LogBuffer other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        IEventRead this$eventRead = this.getEventRead();
        IEventRead other$eventRead = other.getEventRead();
        if (this$eventRead == null ? other$eventRead != null : !this$eventRead.equals(other$eventRead)) {
            return false;
        }
        if (this.getBeginHead() != other.getBeginHead()) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$gtids = this.getGtids();
        String other$gtids = other.getGtids();
        if (this$gtids == null ? other$gtids != null : !this$gtids.equals(other$gtids)) {
            return false;
        }
        Checksum this$checksum = this.getChecksum();
        Checksum other$checksum = other.getChecksum();
        return !(this$checksum == null ? other$checksum != null : !((Object)((Object)this$checksum)).equals((Object)other$checksum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventHeader $head = this.getHead();
        result = result * 59 + ($head == null ? 43 : ((Object)$head).hashCode());
        LogBuffer $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        IEventRead $eventRead = this.getEventRead();
        result = result * 59 + ($eventRead == null ? 43 : $eventRead.hashCode());
        long $beginHead = this.getBeginHead();
        result = result * 59 + (int)($beginHead >>> 32 ^ $beginHead);
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $gtids = this.getGtids();
        result = result * 59 + ($gtids == null ? 43 : $gtids.hashCode());
        Checksum $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)((Object)$checksum)).hashCode());
        return result;
    }

    public String toString() {
        return "EventBean(head=" + this.getHead() + ", body=" + this.getBody() + ", eventRead=" + this.getEventRead() + ", beginHead=" + this.getBeginHead() + ", fileName=" + this.getFileName() + ", gtids=" + this.getGtids() + ", checksum=" + (Object)((Object)this.getChecksum()) + ")";
    }

    private void setEventRead(IEventRead eventRead) {
        this.eventRead = eventRead;
    }

    private void setBeginHead(long beginHead) {
        this.beginHead = beginHead;
    }
}

