/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.PwdUtil;

public abstract class MysqlUtil {
    private static final int[] DIG_TO_BYTES = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4};
    private static final int DIG_PER_DEC = 9;

    public static byte[] password41OrLater(byte[] password, byte[] scramble) {
        byte[] stage1 = PwdUtil.sha((byte[])password);
        byte[] stage2 = PwdUtil.sha((byte[])ByteUtil.concat((byte[])scramble, (byte[])PwdUtil.sha((byte[])stage1)));
        return ByteUtil.xor((byte[])stage1, (byte[])stage2);
    }

    public static int toYear(int value) {
        return 1900 + value;
    }

    public static java.sql.Date toDate(int value) {
        int d = value % 32;
        int m = (value >>>= 5) % 16;
        int y = value >> 4;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(y, m - 1, d);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Time toTime(int value) {
        int s = value % 100;
        int m = (value /= 100) % 100;
        int h = value / 100;
        Calendar c = Calendar.getInstance();
        c.set(1970, 0, 1, h, m, s);
        c.set(14, 0);
        return new Time(c.getTimeInMillis());
    }

    public static Time toTime2(int value, int nanos) {
        int h = value >> 12 & 0x3FF;
        int m = value >> 6 & 0x3F;
        int s = value >> 0 & 0x3F;
        Calendar c = Calendar.getInstance();
        c.set(1970, 0, 1, h, m, s);
        c.set(14, 0);
        long millis = c.getTimeInMillis();
        return new Time(millis + (long)(nanos / 1000000));
    }

    public static Date toDatetime(long value) {
        int second = (int)(value % 100L);
        int minute = (int)((value /= 100L) % 100L);
        int hour = (int)((value /= 100L) % 100L);
        int day = (int)((value /= 100L) % 100L);
        int month = (int)((value /= 100L) % 100L);
        int year = (int)(value / 100L);
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date toDatetime2(long value, int nanos) {
        long x = value >> 22 & 0x1FFFFL;
        int year = (int)(x / 13L);
        int month = (int)(x % 13L);
        int day = (int)(value >> 17) & 0x1F;
        int hour = (int)(value >> 12) & 0x1F;
        int minute = (int)(value >> 6) & 0x3F;
        int second = (int)(value >> 0) & 0x3F;
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, 0);
        long millis = c.getTimeInMillis();
        return new Date(millis + (long)(nanos / 1000000));
    }

    public static Timestamp toTimestamp(long seconds) {
        return new Timestamp(seconds * 1000L);
    }

    public static Timestamp toTimestamp2(long seconds, int nanos) {
        Timestamp r = new Timestamp(seconds * 1000L);
        r.setNanos(nanos);
        return r;
    }

    public static BigDecimal toDecimal(int precision, int scale, byte[] value) {
        int i;
        BigDecimal ip;
        boolean positive = (value[0] & 0x80) == 128;
        value[0] = (byte)(value[0] ^ 0x80);
        if (!positive) {
            int i2 = 0;
            while (i2 < value.length) {
                int n = i2++;
                value[n] = (byte)(value[n] ^ 0xFF);
            }
        }
        int x = precision - scale;
        int ipDigits = x / 9;
        int ipDigitsX = x - ipDigits * 9;
        int ipSize = (ipDigits << 2) + DIG_TO_BYTES[ipDigitsX];
        int offset = DIG_TO_BYTES[ipDigitsX];
        BigDecimal bigDecimal = ip = offset > 0 ? BigDecimal.valueOf(MysqlUtil.bigEndianInteger(value, 0, offset)) : BigDecimal.ZERO;
        while (offset < ipSize) {
            int i3 = MysqlUtil.bigEndianInteger(value, offset, 4);
            ip = ip.movePointRight(9).add(BigDecimal.valueOf(i3));
            offset += 4;
        }
        int shift = 0;
        BigDecimal fp = BigDecimal.ZERO;
        while (shift + 9 <= scale) {
            i = MysqlUtil.bigEndianInteger(value, offset, 4);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(shift + 9));
            shift += 9;
            offset += 4;
        }
        if (shift < scale) {
            i = MysqlUtil.bigEndianInteger(value, offset, DIG_TO_BYTES[scale - shift]);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(scale));
        }
        BigDecimal result = ip.add(fp);
        return positive ? result : result.negate();
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            result = result << 8 | (b >= 0 ? b : b + 256);
        }
        return result;
    }

    public static int getDecimalBinarySize(int precision, int scale) {
        int x = precision - scale;
        int ipd = x / 9;
        int fpd = scale / 9;
        int decimalLength = (ipd << 2) + DIG_TO_BYTES[x - ipd * 9] + (fpd << 2) + DIG_TO_BYTES[scale - fpd * 9];
        return decimalLength;
    }

    public static int compareMulti(String gtid1, String gtid2) {
        String[] argtemp;
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (String hostgitd : gtid1.split(",")) {
            argtemp = hostgitd.split(":");
            map1.put(argtemp[0], argtemp[1]);
        }
        for (String hostgitd : gtid2.split(",")) {
            argtemp = hostgitd.split(":");
            map2.put(argtemp[0], argtemp[1]);
        }
        for (String key : map1.keySet()) {
            String[] tempval2;
            String maxval2;
            String[] tempval1 = ((String)map1.get(key)).split("-");
            String maxval1 = tempval1.length > 1 ? tempval1[1] : tempval1[0];
            if (maxval1.equals(maxval2 = (tempval2 = ((String)map2.get(key)).split("-")).length > 1 ? tempval2[1] : tempval2[0])) continue;
            return Integer.parseInt(maxval1) - Integer.parseInt(maxval2);
        }
        return 0;
    }

    public static int compare(String gtid1, String gtid2) {
        return Integer.parseInt(gtid1.split(":")[1]) - Integer.parseInt(gtid2.split(":")[1]);
    }
}

