/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GtidSet {
    private final Map<String, UUIDSet> map = new LinkedHashMap<String, UUIDSet>();

    public GtidSet(String gtidSet, boolean isSimple) {
        String[] uuidSets;
        gtidSet = gtidSet.replace("\n", "");
        for (String uuidSet : uuidSets = gtidSet.isEmpty() ? new String[]{} : gtidSet.split(",")) {
            String[] rawIntervals;
            int uuidSeparatorIndex = uuidSet.indexOf(":");
            String sourceId = uuidSet.substring(0, uuidSeparatorIndex);
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            for (String interval : rawIntervals = uuidSet.substring(uuidSeparatorIndex + 1).split(":")) {
                String[] is = interval.split("-");
                long[] split = new long[is.length];
                int e = is.length;
                for (int i = 0; i < e; ++i) {
                    split[i] = Long.parseLong(is[i]);
                }
                if (split.length == 1) {
                    split = isSimple ? new long[]{1L, split[0]} : new long[]{split[0], split[0]};
                }
                intervals.add(new Interval(split[0], split[1]));
            }
            this.map.put(sourceId, new UUIDSet(sourceId, intervals));
        }
    }

    public GtidSet(String gtidSet) {
        this(gtidSet, true);
    }

    public Collection<UUIDSet> getUUIDSets() {
        return this.map.values();
    }

    public boolean add(String gtid) {
        String[] split = gtid.split(":");
        String sourceId = split[0];
        long transactionId = Long.parseLong(split[1]);
        UUIDSet uuidSet = this.map.get(sourceId);
        if (uuidSet == null) {
            uuidSet = new UUIDSet(sourceId, new ArrayList());
            this.map.put(sourceId, uuidSet);
        }
        List intervals = (List)uuidSet.intervals;
        int index = GtidSet.findInterval(intervals, transactionId);
        boolean addedToExisting = false;
        if (index < intervals.size()) {
            Interval interval = (Interval)intervals.get(index);
            if (interval.start == transactionId + 1L) {
                interval.start = transactionId;
                addedToExisting = true;
            } else if (interval.end + 1L == transactionId) {
                interval.end = transactionId;
                addedToExisting = true;
            } else if (interval.start <= transactionId && transactionId <= interval.end) {
                return false;
            }
        }
        if (!addedToExisting) {
            intervals.add(index, new Interval(transactionId, transactionId));
        }
        if (intervals.size() > 1) {
            this.joinAdjacentIntervals(intervals, index);
        }
        return true;
    }

    private void joinAdjacentIntervals(List<Interval> intervals, int index) {
        int e = Math.max(index - 1, 0);
        for (int i = Math.min(index + 1, intervals.size() - 1); i > e; --i) {
            Interval a = intervals.get(i - 1);
            Interval b = intervals.get(i);
            if (a.end + 1L != b.start) continue;
            a.end = b.end;
            intervals.remove(i);
        }
    }

    public String toString() {
        ArrayList<String> gtids = new ArrayList<String>();
        for (UUIDSet uuidSet : this.map.values()) {
            gtids.add(uuidSet.getUUID() + ":" + this.join(uuidSet.intervals, ":"));
        }
        return this.join(gtids, ",");
    }

    private static int findInterval(List<Interval> ii, long v) {
        int l = 0;
        int p = 0;
        int r = ii.size();
        while (l < r) {
            p = (l + r) / 2;
            Interval i = ii.get(p);
            if (i.end < v) {
                l = p + 1;
                continue;
            }
            if (v < i.start) {
                r = p;
                continue;
            }
            return p;
        }
        if (!ii.isEmpty() && ii.get(p).end < v) {
            ++p;
        }
        return p;
    }

    private String join(Collection o, String delimiter) {
        if (o.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o1 : o) {
            sb.append(o1).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static final class Interval
    implements Comparable<Interval> {
        private long start;
        private long end;

        private Interval(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        @Override
        public int compareTo(Interval o) {
            return Interval.saturatedCast(this.start - o.start);
        }

        private static int saturatedCast(long value) {
            if (value > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (value < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)value;
        }
    }

    public static final class UUIDSet {
        private String uuid;
        private Collection<Interval> intervals;

        private UUIDSet(String uuid, Collection<Interval> intervals) {
            this.uuid = uuid;
            this.intervals = intervals;
        }

        public String getUUID() {
            return this.uuid;
        }

        public Collection<Interval> getIntervals() {
            return this.intervals;
        }
    }
}

