/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.constant.Checksum;
import net.wicp.tams.common.binlog.self.reader.BinglogReadByFile;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.thread.threadlocal.PerThreadValue;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class DumpByFile {
    private final String dirPath;
    private final String prefix;
    private final String[] binlogFiles;
    private final ISender sender;
    private final String dbPattern;
    private final String tbPattern;
    private final Checksum checksum;
    private ICallBack callBack;
    private int min = -1;
    private int max = -1;
    private final Properties cols = new Properties();
    private String beginGtid;
    private String endGtid;

    public void setCallBack(ICallBack callBack) {
        this.callBack = callBack;
    }

    public DumpByFile(String dirPath, String prefix, String dbPattern, String tbPattern, Checksum checksum, ISender sender) {
        this.dirPath = dirPath;
        this.prefix = prefix;
        this.binlogFiles = null;
        this.sender = sender;
        this.dbPattern = dbPattern;
        this.tbPattern = tbPattern;
        this.checksum = checksum;
    }

    public DumpByFile(String dirPath, String dbPattern, String tbPattern, Checksum checksum, ISender sender, String ... binlogFiles) {
        this.dirPath = dirPath;
        this.prefix = null;
        this.binlogFiles = binlogFiles;
        this.sender = sender;
        this.dbPattern = dbPattern;
        this.tbPattern = tbPattern;
        this.checksum = checksum;
    }

    public void readFile(long beginPos) throws IOException {
        this.readFile(beginPos, -1L);
    }

    public void readFile() throws IOException {
        this.readFile(4L, -1L);
    }

    public void readFile(long beginPos, long endPos) throws IOException {
        Validate.notNull((Object)this.dirPath);
        Validate.notNull((Object)this.sender);
        if (this.cols.isEmpty()) {
            String colnamepropfile = PathType.getPath((String)Conf.get((String)"zorro.binlog.colnamepropfile"));
            this.cols.load(new FileReader(new File(colnamepropfile)));
        }
        if (this.cols == null || this.cols.size() == 0) {
            throw new IllegalAccessError("\u6ca1\u6709\u5217\u5c5e\u6027");
        }
        ArrayList<File> parserFiles = new ArrayList<File>();
        if (this.prefix != null) {
            Collection filelist = FileUtils.listFiles((File)new File(this.dirPath), (IOFileFilter)new IOFileFilter(){

                public boolean accept(File dir, String name) {
                    return true;
                }

                public boolean accept(File file) {
                    boolean check;
                    String filename = file.getName();
                    boolean bl = check = filename.startsWith(DumpByFile.this.prefix + ".") && !filename.endsWith("index");
                    if (!check) {
                        return false;
                    }
                    if (DumpByFile.this.min >= 0 || DumpByFile.this.max >= 0) {
                        int index = Integer.parseInt(filename.substring(filename.indexOf(".") + 1));
                        if (DumpByFile.this.min >= 0 && index < DumpByFile.this.min) {
                            return false;
                        }
                        if (DumpByFile.this.max >= 0 && index > DumpByFile.this.max) {
                            return false;
                        }
                    }
                    return true;
                }
            }, (IOFileFilter)FileFileFilter.FILE);
            parserFiles.addAll(filelist);
        } else if (ArrayUtils.isNotEmpty((Object[])this.binlogFiles)) {
            for (String fileName : this.binlogFiles) {
                parserFiles.add(new File(IOUtil.mergeFolderAndFilePath((String)this.dirPath, (String)fileName)));
            }
        }
        for (File file : parserFiles) {
            BinglogReadByFile reader = new BinglogReadByFile(file, this.dbPattern, this.tbPattern, this.checksum, this.sender);
            PerThreadValue creator = PerthreadManager.getInstance().createValue((Object)"zorro-host");
            Host host = (Host)creator.get((Object)new Host());
            host.addCols(this.cols);
            reader.setEndPos(endPos);
            reader.setBeginGtid(this.beginGtid);
            reader.setEndGtid(this.endGtid);
            reader.read(beginPos);
            reader.close();
            PerthreadManager.getInstance().cleanValue((Object)"zorro-host");
            if (this.callBack == null) continue;
            this.callBack.doCallBack(file);
        }
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public Properties getCols() {
        return this.cols;
    }

    public String getBeginGtid() {
        return this.beginGtid;
    }

    public void setBeginGtid(String beginGtid) {
        this.beginGtid = beginGtid;
    }

    public String getEndGtid() {
        return this.endGtid;
    }

    public void setEndGtid(String endGtid) {
        this.endGtid = endGtid;
    }

    public static interface ICallBack {
        public void doCallBack(File var1);
    }
}

