/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.self;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.SocketUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.GtidSet;
import net.wicp.tams.common.binlog.self.bean.CountNum;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.bean.Pos;
import net.wicp.tams.common.binlog.self.bean.RsCol;
import net.wicp.tams.common.binlog.self.constant.Capability;
import net.wicp.tams.common.binlog.self.constant.Checksum;
import net.wicp.tams.common.binlog.self.constant.Command;
import net.wicp.tams.common.binlog.self.reader.BinglogReadDump;
import net.wicp.tams.common.binlog.self.replication.down.AbsResultPacket;
import net.wicp.tams.common.binlog.self.replication.down.EOFPacket;
import net.wicp.tams.common.binlog.self.replication.down.ErrorPacket;
import net.wicp.tams.common.binlog.self.replication.down.GreetingPacket;
import net.wicp.tams.common.binlog.self.replication.down.OKPacket;
import net.wicp.tams.common.binlog.self.replication.down.RsFieldPacket;
import net.wicp.tams.common.binlog.self.replication.down.RsHeaderPacket;
import net.wicp.tams.common.binlog.self.replication.down.RsRowPacket;
import net.wicp.tams.common.binlog.self.replication.up.SecurePasswordAuthenticationPacket;
import net.wicp.tams.common.binlog.self.replication.up.command.AbsCommand;
import net.wicp.tams.common.binlog.self.replication.up.command.ComBinlogDump;
import net.wicp.tams.common.binlog.self.replication.up.command.ComBinlogDumpGtid;
import net.wicp.tams.common.binlog.self.replication.up.command.ComInitDb;
import net.wicp.tams.common.binlog.self.replication.up.command.ComQuery;
import net.wicp.tams.common.binlog.self.replication.up.command.SingleCommand;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.io.OutputStreamBufferedWrite;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dump {
    private static final Logger log = LoggerFactory.getLogger(Dump.class);
    private final String host;
    private final int port;
    private Socket socket;
    OutputStreamBufferedWrite out;
    InputStream in;
    private boolean isLogin = false;
    private BinglogReadDump binlogParser;

    public Dump(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Dump(String host) {
        this(host, 3306);
    }

    public Result login(String user, String pwd, String defaultSchema) throws IOException {
        try {
            if (this.socket == null || this.socket.isClosed()) {
                this.socket = SocketUtil.create((String)this.host, (int)this.port);
            }
            this.out = new OutputStreamBufferedWrite(this.socket.getOutputStream());
            this.in = this.socket.getInputStream();
        }
        catch (Exception e) {
            throw new IllegalAccessError(String.format("\u4e0d\u80fd\u8fde\u63a5\u5230\u4e3b\u673a:[%s]\uff0c\u7aef\u53e3\uff1a[%s]", this.host, this.port));
        }
        PacketBean greatBean = PacketBean.buildBean(this.in);
        if (greatBean.getPacketMarker() == -1) {
            ErrorPacket error = new ErrorPacket(greatBean);
            return Result.getError((String)"\u6b22\u8fce\u5305\u9519\u8bef").setRetObjs(new Object[]{error});
        }
        Host hostpre = (Host)PerthreadManager.getInstance().createValue((Object)"zorro-host").get((Object)new Host());
        hostpre.setHostIp(this.host);
        hostpre.setPort(this.port);
        hostpre.setUser(user);
        hostpre.setPwd(pwd);
        hostpre.setDefaultDb(defaultSchema);
        PerthreadManager.getInstance().createValue((Object)"zorro-host").set((Object)hostpre);
        GreetingPacket greetingPacket = new GreetingPacket(greatBean);
        SecurePasswordAuthenticationPacket pa = new SecurePasswordAuthenticationPacket(greetingPacket);
        pa.setUser(user);
        pa.setPassword(pwd);
        pa.setDefaultSchema(defaultSchema);
        byte[] bytes = pa.writeBody();
        this.out.write(bytes);
        this.out.flush();
        PacketBean loginRetBean = PacketBean.buildBean(this.in);
        if (loginRetBean.getPacketMarker() == -1) {
            ErrorPacket error = new ErrorPacket(loginRetBean);
            return Result.getError((String)"\u767b\u9646\u5931\u8d25").setRetObjs(new Object[]{error});
        }
        if (loginRetBean.getPacketMarker() == 0) {
            this.isLogin = true;
            OKPacket oKPacket = new OKPacket(loginRetBean);
            return Result.getSuc().setRetObjs(new Object[]{oKPacket});
        }
        return Result.getError((String)String.format("\u4e0d\u652f\u6301\u7684MARKER\uff1a[%s]", loginRetBean.getPacketMarker())).setRetObjs(new Object[]{loginRetBean});
    }

    public void dumpLog(String binlogFilename, long binlogPos, long ServerId, boolean curFile, String dbPattern, String tbPattern, CountNum countNum, ISender ... senders) throws IOException {
        this.dumpLogCommon(null, binlogFilename, binlogPos, ServerId, curFile, dbPattern, tbPattern, countNum, senders);
    }

    public void dumpLogGtid(String gtidStr, String binlogFilename, long binlogPos, long ServerId, boolean curFile, String dbPattern, String tbPattern, CountNum countNum, ISender ... senders) throws IOException {
        if (StringUtil.isNull((Object)gtidStr)) {
            throw new IllegalArgumentException("gtidStr\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dumpLogCommon(gtidStr, binlogFilename, binlogPos, ServerId, curFile, dbPattern, tbPattern, countNum, senders);
    }

    public void dumpLogGtid(String gtidStr, long ServerId, boolean curFile, String dbPattern, String tbPattern, CountNum countNum, ISender ... senders) throws IOException {
        this.dumpLogGtid(gtidStr, "", 4L, ServerId, curFile, dbPattern, tbPattern, countNum, senders);
    }

    private void dumpLogCommon(String gtidStr, String binlogFilename, long binlogPos, long ServerId, boolean curFile, String dbPattern, String tbPattern, CountNum countNum, ISender ... senders) throws IOException {
        if (binlogPos < 4L) {
            throw new IllegalAccessError("\u5f00\u59cb\u4f4d\u7f6e\u6700\u5c0f\u4e3a4");
        }
        if (!this.isLogin) {
            throw new IllegalAccessError("\u6ca1\u6709\u767b\u9646");
        }
        long masterServerId = this.getMasterServerId();
        this.sendSql("SET @master_binlog_checksum='@@global.binlog_checksum'");
        this.sendSql(String.format("SET @mariadb_slave_capability='%s'", Capability.gtid.getValue()));
        String uuid = this.getUUID();
        Checksum checksum = this.getBinlogChecksum();
        boolean gtidCan = this.isAvailable(gtidStr, uuid);
        log.info("gtid\uff1a[{}]\u662f\u5426\u53ef\u7528\uff1a[{}]", (Object)gtidStr, (Object)gtidCan);
        AbsCommand pack = null;
        if (gtidCan) {
            ComBinlogDumpGtid comBinlogDumpGtid = new ComBinlogDumpGtid();
            GtidSet gtidSet = new GtidSet(gtidStr);
            comBinlogDumpGtid.setGtidSet(gtidSet);
            comBinlogDumpGtid.setBinlogFilename("");
            comBinlogDumpGtid.setBinlogPos(4L);
            comBinlogDumpGtid.setServerId(ServerId);
            pack = comBinlogDumpGtid;
        } else {
            ComBinlogDump comBinlogDump = new ComBinlogDump();
            comBinlogDump.setBinlogFilename(binlogFilename);
            comBinlogDump.setBinlogPos(binlogPos);
            comBinlogDump.setFlags(0);
            comBinlogDump.setServerId(ServerId);
            pack = comBinlogDump;
        }
        byte[] input = pack.writeBody();
        this.out.write(input);
        this.out.flush();
        PacketBean binlogPacketBean = PacketBean.buildBean(this.in);
        if (binlogPacketBean.getPacketMarker() == -1) {
            ErrorPacket binPacket = new ErrorPacket(binlogPacketBean);
            log.error("\u6587\u4ef6[{}],\u4f4d\u7f6e\uff1a[{}] \u4e0b\u8f7dbinlog\u65f6\u51fa\u9519\uff1a[{}]", new Object[]{binlogFilename, binlogPos, binPacket.getBody().toJSONString()});
        } else {
            log.info("\u4e0b\u8f7dbinlog\u6210\u529f\uff0c\u6587\u4ef6\u540d\uff1a[{}],\u4f4d\u7f6e\uff1a[{}],\u670d\u52a1ID:[{}],\u5185\u5bb9\uff1a[{}]", new Object[]{binlogFilename, binlogPos, ServerId, binlogPacketBean.getBody()});
            this.binlogParser = new BinglogReadDump(uuid, checksum, this.in, dbPattern, tbPattern, senders);
            this.binlogParser.setFileName(binlogFilename);
            this.binlogParser.setCurFile(curFile);
            this.binlogParser.setMasterServerId(masterServerId);
            this.binlogParser.setGtids(gtidStr);
            if (countNum != null) {
                this.binlogParser.initCountNum(countNum);
            }
            try {
                this.binlogParser.read(binlogPos);
            }
            catch (Throwable e) {
                log.error("\u8bfbbinlog\u65e5\u5fd7\u51fa\u73b0\u95ee\u9898", e);
            }
        }
        this.destory();
    }

    public long getMasterServerId() throws IOException {
        String retstr = this.getVar("server_id", false);
        return Long.valueOf(retstr);
    }

    public YesOrNo getGtidSupport() throws IOException {
        String retstr = this.getVar("gtid_mode", true);
        return "ON".equals(retstr) ? YesOrNo.yes : YesOrNo.no;
    }

    public String getUUID() throws IOException {
        return this.getVar("server_uuid", false);
    }

    public String getGtidPurged() throws IOException {
        return this.getVar("GTID_PURGED", true);
    }

    public String getGtidExecuted() throws IOException {
        return this.getVar("GTID_Executed", true);
    }

    public String getVar(String var, boolean isGlobal) throws IOException {
        List<List<RsCol>> rslist = this.sqlQuery(String.format("select @@%s%s", isGlobal ? "GLOBAL." : "", var));
        RsCol rscol = rslist.get(0).get(0);
        return rscol.getValStr().replace("\n", "");
    }

    public Checksum getBinlogChecksum() throws IOException {
        List<List<RsCol>> rslist = this.sqlQuery("select @@binlog_checksum");
        RsCol rscol = rslist.get(0).get(0);
        String checksumStr = rscol.getValStr().replace("\n", "");
        return Checksum.get(checksumStr);
    }

    public boolean isAvailable(String gtidStr, String uuid) throws IOException {
        if (StringUtil.isNull((Object)gtidStr)) {
            return false;
        }
        long maxGtidDel = this.maxGtid(this.getGtidPurged(), uuid);
        long maxGtidCur = this.maxGtid(gtidStr.replace("\n", ""), uuid);
        return maxGtidDel == 0L || maxGtidDel > 0L && maxGtidCur > 0L && maxGtidCur > maxGtidDel;
    }

    private long maxGtid(String gtidStr, String uuid) {
        if (StringUtil.isNull((Object)gtidStr)) {
            return 0L;
        }
        String[] gtidAry = gtidStr.split(",");
        long delmax = 0L;
        for (String eleGtid : gtidAry) {
            if (!eleGtid.startsWith(uuid)) continue;
            int index1 = eleGtid.lastIndexOf(":");
            String[] nums = eleGtid.substring(index1 + 1).split("-");
            String delNumStr = nums.length > 1 ? nums[1] : nums[0];
            delmax = Long.parseLong(delNumStr);
            break;
        }
        return delmax;
    }

    public PacketBean sendSql(String sql) throws IOException {
        ComQuery common = new ComQuery();
        common.setSql(sql);
        byte[] input = common.writeBody();
        this.out.write(input);
        this.out.flush();
        PacketBean packet = PacketBean.buildBean(this.in);
        return packet;
    }

    public Pos getDumpPos() {
        return this.binlogParser == null ? null : this.binlogParser.curPos();
    }

    public CountNum getCountNum() {
        return this.binlogParser == null ? null : this.binlogParser.getCountNum();
    }

    public BinglogReadDump getBinlogParser() {
        return this.binlogParser;
    }

    public void dumpLog(String binlogFilename, long binlogPos, long ServerId, String dbPattern, String tbPattern, CountNum countNum, ISender ... senders) throws IOException {
        this.dumpLog(binlogFilename, binlogPos, ServerId, false, dbPattern, tbPattern, countNum, senders);
    }

    public List<List<RsCol>> sqlQuery(String sql) throws IOException {
        if (!this.isLogin) {
            throw new IllegalAccessError("\u6ca1\u6709\u767b\u9646");
        }
        ComQuery common = new ComQuery();
        common.setSql(sql);
        byte[] input = common.writeBody();
        this.out.write(input);
        this.out.flush();
        PacketBean packet = PacketBean.buildBean(this.in);
        ArrayList<List<RsCol>> retlist = new ArrayList<List<RsCol>>();
        if (packet.getPacketMarker() == -1) {
            ErrorPacket binPacket = new ErrorPacket(packet);
            log.error("\u67e5\u8be2\u65f6\u51fa\u9519\uff1a[{}]", (Object)binPacket.getBody().toJSONString());
        } else {
            RsHeaderPacket rshead = new RsHeaderPacket(packet);
            System.out.println(rshead.getFieldCount());
            ArrayList<RsFieldPacket> fieldList = new ArrayList<RsFieldPacket>();
            while (true) {
                if ((packet = PacketBean.buildBean(this.in)).getPacketMarker() == -2) break;
                RsFieldPacket field = new RsFieldPacket(packet);
                log.info("{}", (Object)field.getBody().toJSONString());
                fieldList.add(field);
            }
            EOFPacket eof = new EOFPacket(packet);
            log.info("{}", (Object)eof);
            while (true) {
                if ((packet = PacketBean.buildBean(this.in)).getPacketMarker() == -2) {
                    eof = new EOFPacket(packet);
                    log.info("{}", (Object)eof);
                    break;
                }
                ArrayList<RsCol> rowvalue = new ArrayList<RsCol>();
                RsRowPacket row = new RsRowPacket(packet);
                log.info("{}", (Object)row.getBody().toJSONString());
                for (int i = 0; i < fieldList.size(); ++i) {
                    RsCol tempobj = RsCol.builder().columnType(((RsFieldPacket)fieldList.get(i)).getFieldType()).valStr(row.getColumns().get(i)).build();
                    rowvalue.add(tempobj);
                }
                retlist.add(rowvalue);
            }
        }
        return retlist;
    }

    public AbsResultPacket sendSingleCommand(Command command) throws IOException {
        if (!this.isLogin) {
            throw new IllegalAccessError("\u6ca1\u6709\u767b\u9646");
        }
        SingleCommand singleCommand = new SingleCommand(command);
        this.sendCommon(singleCommand);
        return this.retResult();
    }

    public AbsResultPacket setDefaultDb(String defaultDb) throws IOException {
        if (!this.isLogin) {
            throw new IllegalAccessError("\u6ca1\u6709\u767b\u9646");
        }
        ComInitDb c = new ComInitDb();
        c.setDefaultSchema(defaultDb);
        this.sendCommon(c);
        return this.retResult();
    }

    private void sendCommon(AbsCommand command) throws IOException {
        byte[] input = command.writeBody();
        this.out.write(input);
        this.out.flush();
    }

    private AbsResultPacket retResult() throws IOException {
        PacketBean packet = PacketBean.buildBean(this.in);
        if (packet.getPacketMarker() == -1) {
            return new ErrorPacket(packet);
        }
        if (packet.getPacketMarker() == 0) {
            return new OKPacket(packet);
        }
        return null;
    }

    public void destory() throws IOException {
        this.isLogin = false;
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }
}

