package net.wicp.tams.common.binlog.self.replication.up.command;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil.AssitWrite;
import net.wicp.tams.common.binlog.self.constant.Command;

/***
 * 适合的命令有 Command.COM_RESET_CONNECTION
 * 
 * @author andy.zhou
 *
 */
public class SingleCommand extends AbsCommand {
	private static final long serialVersionUID = 1L;

	public SingleCommand(Command command) {
		super(command);
	}

	@Override
	public void packPacket(AssitWrite assit) {
		assit.write(command.getValue(), 1);
	}

	@Override
	protected Result check() {
		if (command == null || !command.isSingle()) {
			return Result.getError("此命令[" + command.name() + "]不适合");
		}
		return Result.getSuc();
	}

}
