package net.wicp.tams.common.binlog.self.replication.up.command;

import java.io.UnsupportedEncodingException;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil.AssitWrite;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.constant.Command;

public class ComQuery extends AbsCommand {
	public ComQuery() {
		super(Command.COM_QUERY);
	}

	@Override
	public void packPacket(AssitWrite assit) {
		assit.write(command.getValue(), 1);
		try {
			assit.write(sql.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
		}
	}

	private static final long serialVersionUID = 1L;
	private String sql;

	public String getSql() {
		return sql;
	}

	public void setSql(String sql) {
		this.sql = sql;
	}

	@Override
	protected Result check() {
		if (StringUtil.isNull(sql)) {
			return Result.getError("不能缺少sql");
		}
		return Result.getSuc();
	}

}
