package net.wicp.tams.common.binlog.self.replication.up.command;

import java.io.UnsupportedEncodingException;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil.AssitWrite;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.constant.Command;

public class ComInitDb extends AbsCommand {
	private static final long serialVersionUID = 1L;
	private String defaultSchema;

	public ComInitDb() {
		super(Command.COM_INIT_DB);
	}

	@Override
	public void packPacket(AssitWrite assit) {
		assit.write(command.getValue(), 1);
		try {
			assit.write(defaultSchema.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
		}
	}

	public String getDefaultSchema() {
		return defaultSchema;
	}

	public void setDefaultSchema(String defaultSchema) {
		this.defaultSchema = defaultSchema;
	}

	@Override
	protected Result check() {
		if (StringUtil.isNull(defaultSchema)) {
			return Result.getError("需要默认的数据库");
		}
		return Result.getSuc();
	}

}
