package net.wicp.tams.common.binlog.self.replication.up.command;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil.AssitWrite;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.constant.Command;

public class ComBinlogDump extends AbsCommand {
	private static final long serialVersionUID = 1L;
	private long binlogPos;
	private int flags;
	private long serverId;
	private String binlogFilename;

	public ComBinlogDump() {
		super(Command.COM_BINLOG_DUMP);
	}

	@Override
	public void packPacket(AssitWrite assit) {
		assit.write(command.getValue(), 1);
		assit.write(binlogPos, 4);
		assit.write(flags, 2);
		assit.write(serverId, 4);
		assit.write(binlogFilename);
	}

	@Override
	protected Result check() {
		if (StringUtil.isNull(binlogFilename) || binlogPos < 0 || serverId <= 0) {
			return Result.getError("日志文件名不能为空、开始位置需大于等于0、服务器Id需大于0");
		}
		return Result.getSuc();
	}

	public long getBinlogPos() {
		return binlogPos;
	}

	public void setBinlogPos(long binlogPos) {
		this.binlogPos = binlogPos;
	}

	public int getFlags() {
		return flags;
	}

	public void setFlags(int flags) {
		this.flags = flags;
	}

	public long getServerId() {
		return serverId;
	}

	public void setServerId(long serverId) {
		this.serverId = serverId;
	}

	public String getBinlogFilename() {
		return binlogFilename;
	}

	public void setBinlogFilename(String binlogFilename) {
		this.binlogFilename = binlogFilename;
	}

}
