package net.wicp.tams.common.binlog.self.replication.up;

import java.io.UnsupportedEncodingException;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil.AssitWrite;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.self.MysqlUtil;
import net.wicp.tams.common.binlog.self.constant.CapabilityFlags;
import net.wicp.tams.common.binlog.self.replication.AbsPacketWrite;
import net.wicp.tams.common.binlog.self.replication.down.GreetingPacket;

public class SecurePasswordAuthenticationPacket extends AbsPacketWrite {
	private static final long serialVersionUID = 1L;

	private final GreetingPacket greetingPacket;
	private String user;
	private String password;
	private String defaultSchema;// 默认数据库
	private int clientCapabilities;
	private int maximumPacketLength;
	protected int clientCollation;

	public SecurePasswordAuthenticationPacket(GreetingPacket greetingPacket) {
		this.greetingPacket = greetingPacket;
	}

	@Override
	public void packPacket(AssitWrite assit) {
		assit.write(buildClientCapabilities(), 4);
		assit.write(this.maximumPacketLength, 4);
		assit.write(this.clientCollation > 0 ? this.clientCollation : greetingPacket.getServerCollation(), 1);
		assit.write((byte) 0, 23);// Fixed, all 0
		try {
			assit.writeEndNull(user.getBytes("UTF-8"));
			assit.write(20, 1);// the length of the SHA1 encrypted password
			assit.write(MysqlUtil.password41OrLater(this.password.getBytes("UTF-8"),
					greetingPacket.getScramble().getBytes("UTF-8")));
			if (StringUtil.isNotNull(this.defaultSchema)) {
				assit.writeEndNull(this.defaultSchema.getBytes("UTF-8"));
			}
		} catch (UnsupportedEncodingException e) {

		}
	}

	@Override
	protected Result check() {
		if (StringUtil.isNull(user) || StringUtil.isNull(password) || greetingPacket == null) {
			return Result.getError("非法参数，用户名、密码、欢迎包不能为空");
		}
		return Result.getSuc();
	}

	protected int buildClientCapabilities() {
		int r = this.clientCapabilities > 0 ? this.clientCapabilities : CapabilityFlags.defaultCapability();
		if (StringUtil.isNotNull(this.defaultSchema)) {
			r |= CapabilityFlags.CLIENT_CONNECT_WITH_DB.getValue();
		}
		return r;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getDefaultSchema() {
		return defaultSchema;
	}

	public void setDefaultSchema(String defaultSchema) {
		this.defaultSchema = defaultSchema;
	}

	public int getClientCapabilities() {
		return clientCapabilities;
	}

	public void setClientCapabilities(int clientCapabilities) {
		this.clientCapabilities = clientCapabilities;
	}

	public int getMaximumPacketLength() {
		return maximumPacketLength;
	}

	public void setMaximumPacketLength(int maximumPacketLength) {
		this.maximumPacketLength = maximumPacketLength;
	}

	public int getClientCollation() {
		return clientCollation;
	}

	public void setClientCollation(int clientCollation) {
		this.clientCollation = clientCollation;
	}

}
