package net.wicp.tams.common.binlog.self.replication.down;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.replication.AbsPacketRead;

public class RsRowPacket extends AbsPacketRead {
	private static final long serialVersionUID = 1L;
	private List<String> columns;

	public RsRowPacket(PacketBean packetBean) {
		super(packetBean);
	}

	@Override
	public JSONObject getBody() {
		JSONArray cols = new JSONArray();
		for (String column : columns) {
			cols.add(column);
		}
		return JSONUtil.packParams("columns", cols);
	}

	@Override
	protected void readBody() throws IOException {
		if (this.columns == null) {// 因为在父构造里执行，会先执行它再执行本类构造
			this.columns = new ArrayList<>();
		}
		while (buff.hasRemaining()) {
			String colstr = buff.getStringPackLong(this.charsetName);// reader.readStringUnsignedLong();
			columns.add(colstr);
		}
	}

	public List<String> getColumns() {
		return columns;
	}
}
