package net.wicp.tams.common.binlog.self.replication.down;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.replication.AbsPacketRead;

/**
 * sql查询时的头
 * 
 * @author andy.zhou
 *
 */
public class RsHeaderPacket extends AbsPacketRead {
	private static final long serialVersionUID = 1L;
	private long fieldCount;
	private long extra;

	public RsHeaderPacket(PacketBean packetBean) {
		super(packetBean);
	}

	@Override
	public JSONObject getBody() {
		JSONObject retobj = JSONUtil.packParams("fieldCount", fieldCount, "extra", extra);
		return retobj;
	}

	@Override
	protected void readBody() throws IOException {
		fieldCount = buff.getPackedLong();// reader.readUnsignedLong();
		if (buff.hasRemaining())
			extra = buff.getPackedLong();// reader.readUnsignedLong();
	}

	public long getFieldCount() {
		return fieldCount;
	}

	public long getExtra() {
		return extra;
	}

}
