package net.wicp.tams.common.binlog.self.replication.down;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.binlog.self.replication.AbsPacketRead;

public class RsFieldPacket extends AbsPacketRead {
	private static final long serialVersionUID = 1L;

	public RsFieldPacket(PacketBean packetBean) {
		super(packetBean);
	}

	//
	private String catalog;
	private String db;
	private String table;
	private String orginalTable;
	private String column;
	private String originalColumn;
	private int fixed12;
	private int charset;
	private long fieldLength;
	private ColumnType fieldType;
	private int fieldOptions;
	private int decimalPrecision;
	private int reserved;
	private String defaultValue; // Optional

	@Override
	public JSONObject getBody() {
		JSONObject retobj = JSONUtil.packParams("catalog", catalog, "db", db, "table", table, "orginalTable", orginalTable,
				"column", column, "originalColumn", originalColumn, "fixed12", fixed12, "charset", charset,
				"fieldLength", fieldLength, "fieldType", fieldType.name(), "fieldOptions", fieldOptions,
				"decimalPrecision", decimalPrecision, "reserved", reserved, "defaultValue", defaultValue);
		return retobj;
	}

	@Override
	protected void readBody() throws IOException {
		catalog = buff.getStringPackLong(this.charsetName);// reader.getFixString((int)
															// reader.getPackedLong());//
															// .readStringUnsignedLong();
		db = buff.getStringPackLong(this.charsetName);// .readStringUnsignedLong();
		table = buff.getStringPackLong(this.charsetName);// .readStringUnsignedLong();
		orginalTable = buff.getStringPackLong(this.charsetName);// .readStringUnsignedLong();
		column = buff.getStringPackLong(this.charsetName);// .readStringUnsignedLong();
		originalColumn = buff.getStringPackLong(this.charsetName);// .readStringUnsignedLong();
		fixed12 = buff.getInt8();// ByteUtil.readIntL(reader.readBytes(1));
		charset = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		fieldLength = buff.getInt32();// ByteUtil.readLongL(reader.readBytes(4));
		fieldType = ColumnType.get(buff.getUint8());
		fieldOptions = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		decimalPrecision = buff.getInt8();// ByteUtil.readIntL(reader.readBytes(1));
		reserved = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		if (buff.hasRemaining()) {
			defaultValue = buff.getStringPackLong(this.charsetName);// .readStringUnsignedLong();
		}
	}

	public String getCatalog() {
		return catalog;
	}

	public String getDb() {
		return db;
	}

	public String getTable() {
		return table;
	}

	public String getOrginalTable() {
		return orginalTable;
	}

	public String getColumn() {
		return column;
	}

	public String getOriginalColumn() {
		return originalColumn;
	}

	public int getFixed12() {
		return fixed12;
	}

	public int getCharset() {
		return charset;
	}

	public long getFieldLength() {
		return fieldLength;
	}

	public ColumnType getFieldType() {
		return fieldType;
	}

	public int getFieldOptions() {
		return fieldOptions;
	}

	public int getDecimalPrecision() {
		return decimalPrecision;
	}

	public int getReserved() {
		return reserved;
	}

	public String getDefaultValue() {
		return defaultValue;
	}
}
