package net.wicp.tams.common.binlog.self.replication.down;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.constant.StatusFlags;

public class OKPacket extends AbsResultPacket {
	private static final long serialVersionUID = 1L;
	public static final byte PACKET_MARKER = (byte) 0x00;

	private int packetMarker;
	private long affectedRows;
	private long insertId;
	private StatusFlags serverStatus;
	private int warningCount;
	private String message;

	public OKPacket(PacketBean packetBean) {
		super(packetBean);
	}

	@Override
	protected void readBody() throws IOException {
		packetMarker = buff.getInt8();// ByteUtil.readIntL(reader.readBytes(1));
		affectedRows = buff.getPackedLong();// reader.readUnsignedLong();
		insertId = buff.getPackedLong();// reader.readUnsignedLong();
		serverStatus = StatusFlags.get(buff.getInt16());
		warningCount = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		if (buff.hasRemaining())
			message = buff.getStringEndRest(this.charsetName);// ByteUtil.readString(reader.readRest());
	}

	public int getPacketMarker() {
		return packetMarker;
	}

	public long getAffectedRows() {
		return affectedRows;
	}

	public long getInsertId() {
		return insertId;
	}

	public StatusFlags getServerStatus() {
		return serverStatus;
	}

	public int getWarningCount() {
		return warningCount;
	}

	public String getMessage() {
		return message;
	}

	@Override
	public JSONObject getBody() {
		JSONObject retobj = JSONUtil.packParams("affectedRows", affectedRows, "insertId", insertId, "serverStatus",
				serverStatus.name(), "warningCount", warningCount, "message", message);
		return retobj;
	}

	@Override
	public boolean isSuc() {
		return true;
	}

}
