package net.wicp.tams.common.binlog.self.replication.down;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.apiext.ByteUtil.AssitRead;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.constant.CapabilityFlags;
import net.wicp.tams.common.binlog.self.constant.CharacterSet;
import net.wicp.tams.common.binlog.self.replication.AbsPacketRead;

public class GreetingPacket extends AbsPacketRead {
	private static final long serialVersionUID = 1L;

	int protocolVersion;
	String serverVersion;
	long connectionId;
	CharacterSet characterSet;// TODO 新的
	int serverCapabilities;

	// 旧的
	private String scramble1;
	private int serverCollation;
	private int serverStatus;
	private String scramble2;
	private String pluginProvidedData;

	public String getScramble() {
		return scramble1 + scramble2;
	}

	@Override
	protected void readBody() throws IOException {
		protocolVersion = buff.getInt8();// ByteUtil.readIntL(reader.readBytes(1));
		serverVersion = buff.getStringEndNull(this.charsetName);// reader.readStringEndNull();
		connectionId = buff.getInt32();// ByteUtil.readLongL(reader.readBytes(4));
		scramble1 = buff.getStringEndNull(this.charsetName);// reader.readStringEndNull();
		serverCapabilities = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		serverCollation = buff.getInt8();// ByteUtil.readIntL(reader.readBytes(1));
		serverStatus = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		buff.forward(13);// reader.skip(13);
		scramble2 = buff.getStringEndNull(this.charsetName);// reader.readStringEndNull();
		if (buff.hasRemaining()) {
			pluginProvidedData = buff.getStringEndNull(this.charsetName);
		}
	}

	/***
	 * 新格式解析
	 * 
	 * @throws IOException
	 */
	public void readBodyNew(AssitRead reader) throws IOException {
		System.out.println(packetBean.getBody());
		protocolVersion = ByteUtil.readIntL(reader.readBytes(1));
		serverVersion = reader.readStringEndNull();
		connectionId = ByteUtil.readLongL(reader.readBytes(4));

		String authPluginDataPart1 = ByteUtil.readString(reader.readBytes(8));
		reader.skip(1);// filler_1 跳过
		byte[] capabilityFlags1 = reader.readBytes(2);// lower 2 bytes of the
														// Protocol::CapabilityFlags
														// (optional)
		if (reader.hasMore()) {
			characterSet = CharacterSet.get(reader.readByte());
			reader.skip(2);// status flags
			byte[] capabilityFlags2 = reader.readBytes(2);// upper 2 bytes of
															// the
															// Protocol::CapabilityFlags
			byte[] capabilitiesByte = new byte[] { capabilityFlags2[0], capabilityFlags2[1], capabilityFlags1[0],
					capabilityFlags1[1] };

			serverCapabilities = (int) ByteUtil.readLongB(capabilitiesByte);
			int authPluginDataLength = 0;
			if ((serverCapabilities & CapabilityFlags.CLIENT_PLUGIN_AUTH.getValue()) != 0x0000) {
				authPluginDataLength = ByteUtil.readIntL(reader.readBytes(1));
			}
			reader.skip(10);// reserved (all [00])
			/**
			 * if capabilities & CLIENT_SECURE_CONNECTION { string[$len]
			 * auth-plugin-data-part-2 ($len=MAX(13, length of auth-plugin-data
			 * - 8)) if capabilities & CLIENT_PLUGIN_AUTH { string[NUL]
			 * auth-plugin name }
			 */

		}
	}

	public int getProtocolVersion() {
		return protocolVersion;
	}

	public String getServerVersion() {
		return serverVersion;
	}

	public long getConnectionId() {
		return connectionId;
	}

	public CharacterSet getCharacterSet() {
		return characterSet;
	}

	public int getServerCapabilities() {
		return serverCapabilities;
	}

	public int getServerCollation() {
		return serverCollation;
	}

	public int getServerStatus() {
		return serverStatus;
	}

	public String getPluginProvidedData() {
		return pluginProvidedData;
	}

	public GreetingPacket(PacketBean packetBean) {
		super(packetBean);
	}

	@Override
	public JSONObject getBody() {
		JSONObject retobj = JSONUtil.packParams("protocolVersion", protocolVersion, "serverVersion", serverVersion,
				"connectionId", connectionId, "serverCapabilities", serverCapabilities, "scramble", getScramble(),
				"serverCollation", serverCollation, "serverStatus", serverStatus);
		return retobj;
	}

}
