package net.wicp.tams.common.binlog.self.replication.down;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;

public class ErrorPacket extends AbsResultPacket {
	private static final long serialVersionUID = 1L;

	public static final byte PACKET_MARKER = (byte) 0xFF;
	int errorCode;
	String sqlStateMarker;
	String sqlState;
	String errorMessage;

	public ErrorPacket(PacketBean packetBean) {
		super(packetBean);
	}

	@Override
	protected void readBody() throws IOException {
		buff.forward(1);// reader.skip(1);// PACKET_MARKER
		errorCode = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		// if capabilities & CLIENT_PROTOCOL_41 {
		sqlStateMarker = buff.getFullString(1, this.charsetName);// buff.getFixString(buff.getInt8());//
		// ByteUtil.readString(reader.readBytes(1));
		sqlState = buff.getFullString(5, this.charsetName); // ByteUtil.readString(reader.readBytes(5));
		errorMessage = buff.getStringEndRest(this.charsetName); // ByteUtil.readString(reader.readRest());
	}

	@Override
	public JSONObject getBody() {
		JSONObject retobj = JSONUtil.packParams("errorCode", errorCode, "sqlStateMarker", sqlStateMarker, "sqlState",
				sqlState, "errorMessage", errorMessage);
		return retobj;
	}

	@Override
	public boolean isSuc() {
		return false;
	}

}
