package net.wicp.tams.common.binlog.self.replication.down;

import java.io.IOException;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.binlog.self.bean.PacketBean;
import net.wicp.tams.common.binlog.self.constant.StatusFlags;
import net.wicp.tams.common.binlog.self.replication.AbsPacketRead;

/****
 * 结束
 * 
 * @author andy.zhou
 *
 */
public class EOFPacket extends AbsPacketRead {
	private static final long serialVersionUID = 1L;
	public static final byte PACKET_MARKER = (byte) 0xFE;
	private int warningCount;
	private StatusFlags serverStatus;

	public EOFPacket(PacketBean packetBean) {
		super(packetBean);
	}

	@Override
	public JSONObject getBody() {
		JSONObject retobj =   JSONUtil.packParams("warningCount", warningCount, "serverStatus",
				serverStatus == null ? "" : serverStatus.name());
		return retobj;
	}

	@Override
	protected void readBody() throws IOException {
		buff.forward(1);// reader.skip(1);// PACKET_MARKER
		warningCount = buff.getInt16();// ByteUtil.readIntL(reader.readBytes(2));
		serverStatus = StatusFlags.get(buff.getInt16());
	}

}
