package net.wicp.tams.common.binlog.self.event;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.self.LogBuffer;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.bean.Host;
import net.wicp.tams.common.binlog.self.bean.TableMapBean;
import net.wicp.tams.common.binlog.self.constant.ColumnType;
import net.wicp.tams.common.binlog.self.sender.ISender;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class TableMapEvent extends AbsEvent {
	private long tableId;
	private int flags;
	private String schemaName;
	private String tableName;
	private long columnCount;
	private ColumnType[] columnTypes;
	private int[] metaDefs;
	private byte[] nullBits;

	// columns present bitmap的bits set个数来

	public TableMapEvent(EventBean event) {
		super(event);
		event.getBody().limit(event.getBody().limit() + event.getChecksum().getByteNum());// TableMap需要特别处理，它不传校验码
	}

	@Override
	public Result parseBody(ISender... senders) {
		int postHeadLength = event.getHead().getEventType().getPostHeaderLength();
		if (postHeadLength == -1) {
			return Result.getError("没有初始化，FormatDescription事件必须第一个读.");
		}
		if (postHeadLength == 6) {
			tableId = super.logBuffer.getInt32();// ByteUtil.readLongL(assitRead.readBytes(4));
		} else {
			tableId = super.logBuffer.getLong48();// ByteUtil.readLongL(assitRead.readBytes(6));
		}
		Host host = (Host) PerthreadManager.getInstance().createValue("zorro-host").get(new Host());
		if (host.containsTabId(tableId)) {
			return Result.getSuc("已存在该表，无需解析");
		}

		flags = super.logBuffer.getInt16();// ByteUtil.readIntL(assitRead.readBytes(2));
		int schemaNameLength = super.logBuffer.getInt8();// ByteUtil.readIntL(assitRead.readBytes(1));
		schemaName = super.logBuffer.getFixString(schemaNameLength);// ByteUtil.readString(assitRead.readBytes(schemaNameLength));
		super.logBuffer.forward(1);// assitRead.skip(1);
		int tableNameLength = super.logBuffer.getInt8();// int tableNameLength =
														// ByteUtil.readIntL(assitRead.readBytes(1));
		tableName = super.logBuffer.getFixString(tableNameLength);// ByteUtil.readString(assitRead.readBytes(tableNameLength));
		super.logBuffer.forward(1);// assitRead.skip(1);
		if (!host.checkTable(schemaName, tableName)) {
			return Result.getSuc("该表不满足条件，无需解析");
		}
		columnCount = super.logBuffer.getPackedLong();// assitRead.readUnsignedLong();
		columnTypes = new ColumnType[(int) columnCount];
		for (int i = 0; i < columnCount; i++) {
			columnTypes[i] = ColumnType.get(super.logBuffer.getUint8());
		}

		long meteCount = super.logBuffer.getPackedLong();// assitRead.readUnsignedLong();
		LogBuffer meteBytesBuff = super.logBuffer.duplicate((int) meteCount);// assitRead.readBytes(meteCount.intValue());
		metaDefs = new int[(int) columnCount];
		for (int i = 0; i < columnCount; i++) {
			int length = columnTypes[i].getMetaLen();
			if (length <= 0) {
				metaDefs[i] = 0;
				continue;
			}
			switch (columnTypes[i]) {
			case SET:
			case ENUM:
			case STRING:
				metaDefs[i] = (int) meteBytesBuff.readLongB(length);
				break;
			default:
				metaDefs[i] = (int) meteBytesBuff.readLongL(length);// ByteUtil.readIntL(meteBytesBuff.getData(length));
				break;
			}
		}

		int null_bitmapLength = ((int) meteCount + 7) / 8;
		nullBits = super.logBuffer.getData(null_bitmapLength);// assitRead.readBytes(null_bitmapLength);

		host.addTableMapBean(TableMapBean.builder().tableId(tableId).flags(flags).schemaName(schemaName)
				.tableName(tableName).columnCount((int) columnCount).columnTypes(columnTypes).metaDefs(metaDefs)
				.nullBits(nullBits).build());

		return Result.getSuc();
	}

}
