package net.wicp.tams.common.binlog.self.event;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.sender.ISender;

/***
 * The rotate event is added to the binlog as last event to tell the reader what
 * binlog to request next.
 * 
 * @author andy.zhou
 *
 */

public class RotateEvent extends AbsEvent {

	public RotateEvent(EventBean event) {
		super(event);
	}

	private long nextPosition;
	private String nextBinlogName;

	@Override
	public Result parseBody(ISender... senders) {
		nextPosition = super.logBuffer.getLong64();// ByteUtil.readLongL(assitRead.readBytes(8));
		nextBinlogName = super.logBuffer.getStringEndRest(charsetName);// ByteUtil.readString(assitRead.readRest());
		return Result.getSuc();
	}

	public long getNextPosition() {
		return nextPosition;
	}

	public String getNextBinlogName() {
		return nextBinlogName;
	}

}
