package net.wicp.tams.common.binlog.self.event;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ByteUtil;
import net.wicp.tams.common.binlog.self.bean.EventBean;
import net.wicp.tams.common.binlog.self.constant.EventType;
import net.wicp.tams.common.binlog.self.sender.ISender;

public class FormatDescription extends AbsEvent {
	private int binlogVersion;
	private String mysqlVersion;
	private long createtime;
	private int eventHeaderLength;

	public FormatDescription(EventBean event) {
		super(event);
	}

	@Override
	public Result parseBody(ISender... senders) {
		Result ret = Result.getSuc();
		binlogVersion = this.logBuffer.getInt16();// ByteUtil.readIntL(assitRead.readBytes(2));
		mysqlVersion = this.logBuffer.getFixString(50);// //
														// ByteUtil.readString(assitRead.readBytes(50));
		createtime = this.logBuffer.getInt32();// ByteUtil.readLongL(assitRead.readBytes(4));
		eventHeaderLength = this.logBuffer.getInt8();// ByteUtil.readIntL(assitRead.readBytes(1));
		// 设置事件的头长度
		byte[] rest = this.logBuffer.getData(); // assitRead.readRest();
		EventType[] events = EventType.orderFormat();
		for (int i = 0; i < events.length; i++) {
			events[i].setPostHeaderLength(ByteUtil.toUnsigned(rest[i]));
		}
		return ret;
	}

	public int getBinlogVersion() {
		return binlogVersion;
	}

	public String getMysqlVersion() {
		return mysqlVersion;
	}

	public long getCreatetime() {
		return createtime;
	}

	public int getEventHeaderLength() {
		return eventHeaderLength;
	}

}
