package net.wicp.tams.common.binlog.self.constant;

import net.wicp.tams.common.apiext.NumberUtil;

/***
 * 服务器状态，在connect之后返回的ok包中会含有此项
 * 
 * @author zhoujunhui
 *
 */
public enum StatusFlags {
	SERVER_STATUS_IN_TRANS("事务是活动的", 0x0001),

	SERVER_STATUS_AUTOCOMMIT("可以自动提交", 0x0002),

	SERVER_MORE_RESULTS_EXISTS("", 0x0008),

	SERVER_STATUS_NO_GOOD_INDEX_USED("", 0x0010),

	SERVER_STATUS_NO_INDEX_USED("", 0x0020),

	SERVER_STATUS_CURSOR_EXISTS("", 0x0040),

	SERVER_STATUS_LAST_ROW_SENT("", 0x0080),

	SERVER_STATUS_DB_DROPPED("", 0x0100),

	SERVER_STATUS_NO_BACKSLASH_ESCAPES("", 0x0200),

	SERVER_STATUS_METADATA_CHANGED("", 0x0400),

	SERVER_QUERY_WAS_SLOW("", 0x0800),

	SERVER_PS_OUT_PARAMS("", 0x1000),

	SERVER_STATUS_IN_TRANS_READONLY("在一个只读的事务中", 0x2000),

	SERVER_SESSION_STATE_CHANGED("connection state信息已改变", 0x4000);

	private final String desc;
	private final int value;// 值

	private StatusFlags(String desc, int value) {
		this.desc = desc;
		this.value = value;
	}

	public static StatusFlags[] values = new StatusFlags[] { SERVER_STATUS_IN_TRANS, SERVER_STATUS_AUTOCOMMIT,
			SERVER_MORE_RESULTS_EXISTS, SERVER_STATUS_NO_GOOD_INDEX_USED, SERVER_STATUS_NO_INDEX_USED,
			SERVER_STATUS_CURSOR_EXISTS, SERVER_STATUS_LAST_ROW_SENT, SERVER_STATUS_DB_DROPPED,
			SERVER_STATUS_NO_BACKSLASH_ESCAPES, SERVER_STATUS_METADATA_CHANGED, SERVER_QUERY_WAS_SLOW,
			SERVER_PS_OUT_PARAMS, SERVER_STATUS_IN_TRANS_READONLY, SERVER_SESSION_STATE_CHANGED };

	public static StatusFlags get(int val) {
		return values[new Double(NumberUtil.log(val, 2)).intValue()];
	}

	public String getDesc() {
		return desc;
	}

	public int getValue() {
		return value;
	}
}
