package net.wicp.tams.common.binlog.self.constant;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

public enum SenderEnum implements IEnumCombobox {
	log("日志服务", "net.wicp.tams.commons.binlog.sender.impl.LogFile"),

	redis("Redis队列", "net.wicp.tams.commons.binlog.sender.impl.SenderRedis"),

	kafka("kafka消息", "net.wicp.tams.commons.binlog.sender.kafka.SenderKafka"),

	ons("ons消息", "net.wicp.tams.commons.binlog.sender.impl.SenderOns"),

	no("其它发送者", "");

	private final String desc;
	private final String value;// 值

	private SenderEnum(String desc, String value) {
		this.desc = desc;
		this.value = value;
	}

	public static SenderEnum get(String name) {
		for (SenderEnum senderEnum : SenderEnum.values()) {
			if (senderEnum.name().equalsIgnoreCase(name)) {
				return senderEnum;
			}
		}
		return null;
	}

	public String getDesc() {
		return desc;
	}

	public String getValue() {
		return value;
	}

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_en() {
		return this.desc;
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}
}
