package net.wicp.tams.common.binlog.self.constant;

import net.wicp.tams.common.apiext.NumberUtil;

public enum EventFlag {
	LOG_EVENT_BINLOG_IN_USE_F("", (short) 0x01),

	LOG_EVENT_FORCED_ROTATE_F("", (short) 0x02),

	LOG_EVENT_THREAD_SPECIFIC_F("", (short) 0x04),

	LOG_EVENT_SUPPRESS_USE_F("", (short) 0x08),

	LOG_EVENT_UPDATE_TABLE_MAP_VERSION_F("", (short) 0x10),

	LOG_EVENT_ARTIFICIAL_F("", (short) 0x20),

	LOG_EVENT_RELAY_LOG_F("", (short) 0x40),

	LOG_EVENT_IGNORABLE_F("", (short) 0x80),

	LOG_EVENT_NO_FILTER_F("", (short) 0x100),

	LOG_EVENT_MTS_ISOLATE_F("", (short) 0x200);

	private final String desc;
	private final short value;// 值

	private EventFlag(String desc, short value) {
		this.desc = desc;
		this.value = value;
	}

	public String getDesc() {
		return desc;
	}

	public int getValue() {
		return value;
	}

	public static EventFlag[] values = new EventFlag[] { LOG_EVENT_BINLOG_IN_USE_F, LOG_EVENT_FORCED_ROTATE_F,
			LOG_EVENT_THREAD_SPECIFIC_F, LOG_EVENT_SUPPRESS_USE_F, LOG_EVENT_UPDATE_TABLE_MAP_VERSION_F,
			LOG_EVENT_ARTIFICIAL_F, LOG_EVENT_RELAY_LOG_F, LOG_EVENT_IGNORABLE_F, LOG_EVENT_NO_FILTER_F,
			LOG_EVENT_MTS_ISOLATE_F };

	public static EventFlag get(int val) {
		if (val == 0)
			return null;
		return values[new Double(NumberUtil.log(val, 2)).intValue()];
	}
}
