package net.wicp.tams.common.binlog.self.constant;

/***
 * 命令枚举
 * 
 * @author zhoujunhui
 *
 */
public enum Command {
	COM_SLEEP("sleep(内部服务器命令)", (byte) 0x00),

	COM_QUIT("告诉服务器，客户端要关闭", (byte) 0x01, true),

	COM_INIT_DB("改变默认的数据库", (byte) 0x02),

	COM_QUERY("", (byte) 0x03),

	COM_FIELD_LIST("", (byte) 0x04),

	COM_CREATE_DB("", (byte) 0x05),

	COM_DROP_DB("", (byte) 0x06),

	COM_REFRESH("", (byte) 0x07),

	COM_SHUTDOWN("", (byte) 0x08),

	COM_STATISTICS("", (byte) 0x09),

	COM_PROCESS_INFO("", (byte) 0x0a),

	COM_CONNECT("", (byte) 0x0b, true),

	COM_PROCESS_KILL("", (byte) 0x0c),

	COM_DEBUG("", (byte) 0x0d, true),

	COM_PING("", (byte) 0x0e, true),

	COM_TIME("", (byte) 0x0f),

	COM_DELAYED_INSERT("", (byte) 0x10),

	COM_CHANGE_USER("", (byte) 0x11),

	COM_BINLOG_DUMP("下载binlog", (byte) 0x12),

	COM_BINLOG_DUMP_GTID("通过GTID下载binlog", (byte) 0x1e),

	COM_TABLE_DUMP("", (byte) 0x13),

	COM_CONNECT_OUT("", (byte) 0x14),

	COM_REGISTER_SLAVE("", (byte) 0x15),

	COM_STMT_PREPARE("", (byte) 0x16),

	COM_STMT_EXECUTE("", (byte) 0x17),

	COM_STMT_SEND_LONG_DATA("", (byte) 0x18),

	COM_STMT_CLOSE("", (byte) 0x19),

	COM_STMT_RESET("", (byte) 0x1a),

	COM_SET_OPTION("", (byte) 0x1b),

	COM_STMT_FETCH("", (byte) 0x1c),

	COM_DAEMON("", (byte) 0x1d),

	COM_RESET_CONNECTION("重置连接，比COM_CHANGE_USER更轻量，不关闭和重新打开链接，不重新授权", (byte) 0x1f, true);// TODO
																							// 5.6测试时不支持

	private final String desc;
	private final byte value;// 值
	private final boolean single;

	private Command(String desc, byte value) {
		this.desc = desc;
		this.value = value;
		this.single = false;
	}

	private Command(String desc, byte value, boolean isSingle) {
		this.desc = desc;
		this.value = value;
		this.single = isSingle;
	}

	public static Command get(byte val) {
		for (Command command : Command.values()) {
			if (command.getValue() == val) {
				return command;
			}
		}
		return null;
	}

	public String getDesc() {
		return desc;
	}

	public int getValue() {
		return value;
	}

	public boolean isSingle() {
		return single;
	}
}
