package net.wicp.tams.common.binlog.self.constant;

/***
 * TYPE_SET: ENUM: STRING: metadata[i] = CodecUtils.toInt(d.readBytes(2), 0, 2);
 * // Big-endian break;
 * 
 * @author Administrator
 *
 */
public enum ColumnType {
	DECIMAL("", 0x00),

	TINY("", 0x01, 0, 1),

	SHORT("", 0x02, 0, 2),

	LONG("", 0x03, 0, 4),

	FLOAT("", 0x04, 1, 4),

	DOUBLE("", 0x05, 1, 8),

	NULL("", 0x06), // stored in the NULL-bitmap only

	TIMESTAMP("", 0x07, 0),

	LONGLONG("", 0x08, 0, 8),

	INT24("", 0x09, 0, 4),

	DATE("", 0x0a, 0),

	TIME("", 0x0b), // -----

	DATETIME("", 0x0c, 0),

	YEAR("", 0x0d),

	NEWDATE("", 0x0e),

	VARCHAR("", 0x0f, 2), // 2个字节，存储的是string的长度

	BIT("", 0x10, 2),

	TIMESTAMP_V2("", 0x11, 1),

	DATETIME_V2("", 0x12, 1),

	TIME_V2("", 0x13, 1), // 过于复杂，不管

	NEWDECIMAL("", 0xf6, 2), // 过于复杂，不管

	ENUM("", 0xf7, 2),

	SET("", 0xf8, 2), // see MYSQL_TYPE_ENUM

	TINY_BLOB("", 0xf9),

	MEDIUM_BLOB("", 0xfa),

	LONG_BLOB("", 0xfb),

	BLOB("", 0xfc, 1), // 1个字节得到值，1：表明是tiny blob,第1个字节存储blob长度, 2:short
						// blob 前2个字节存blob长度

	VAR_STRING("", 0xfd, 2),

	STRING("", 0xfe, 2),

	GEOMETRY("", 0xff, 1);

	private final String desc;
	private final int value;// 值
	private final int metaLen;
	private final int colLen;

	public static ColumnType[] values1 = new ColumnType[] { DECIMAL, TINY, SHORT, LONG, FLOAT, DOUBLE, NULL, TIMESTAMP,
			LONGLONG, INT24, DATE, TIME, DATETIME, YEAR, NEWDATE, VARCHAR, BIT, TIMESTAMP_V2, DATETIME_V2, TIME_V2 };
	public static ColumnType[] values2 = new ColumnType[] { NEWDECIMAL, ENUM, SET, TINY_BLOB, MEDIUM_BLOB, LONG_BLOB,
			BLOB, VAR_STRING, STRING, GEOMETRY };

	public static ColumnType get(int val) {
		if (val <= TIME_V2.value) {
			return values1[val];
		} else if (val >= NEWDECIMAL.value && val <= GEOMETRY.value) {
			return values2[val - NEWDECIMAL.value];
		} else {
			return null;
		}
	}

	private ColumnType(String desc, int value, int metaLen, int colLen) {
		this.desc = desc;
		this.value = value;
		this.metaLen = metaLen;
		this.colLen = colLen;
	}

	private ColumnType(String desc, int value, int metaLen) {
		this.desc = desc;
		this.value = value;
		this.metaLen = metaLen;
		this.colLen = -1;
	}

	private ColumnType(String desc, int value) {
		this.desc = desc;
		this.value = value;
		this.metaLen = -1;
		this.colLen = -1;
	}

	public String getDesc() {
		return desc;
	}

	public int getValue() {
		return value;
	}

	public int getMetaLen() {
		return metaLen;
	}

	public int getColLen() {
		return colLen;
	}

}
