package net.wicp.tams.common.binlog.self.constant;

public enum CharacterSet {
	big5_chinese_ci("", (byte) 0x01),

	latin2_czech_cs("", (byte) 0x02),

	dec8_swedish_ci("", (byte) 0x03),

	cp850_general_ci("", (byte) 0x04),

	latin1_german1_ci("", (byte) 0x05),

	hp8_english_ci("", (byte) 0x06),

	koi8r_general_ci("", (byte) 0x07),

	latin1_swedish_ci("", (byte) 0x08),

	latin2_general_ci("", (byte) 0x09),

	swe7_swedish_ci("", (byte) 0x0a),

	utf8_general_ci("", (byte) 0x21),

	binary("", (byte) 0x63);

	private final String desc;

	private final byte value;

	private CharacterSet(String desc, byte value) {
		this.desc = desc;
		this.value = value;
	}

	public static CharacterSet get(byte val) {
		for (CharacterSet characterSet : CharacterSet.values()) {
			if (characterSet.getValue() == val) {
				return characterSet;
			}
		}
		return null;
	}

	public byte getValue() {
		return value;
	}

	public String getDesc() {
		return desc;
	}

}
